/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.webhooks.plugin.validator;

import com.atlassian.sal.api.message.I18nResolver;
import com.atlassian.webhooks.api.register.listener.PersistentWebHookListener;
import com.atlassian.webhooks.api.util.ErrorMessage;
import com.atlassian.webhooks.api.util.MessageCollection;
import com.atlassian.webhooks.plugin.module.WebHookPluginRegistrationContainer;
import com.atlassian.webhooks.plugin.validator.EventsValidator;
import com.atlassian.webhooks.plugin.validator.UrlValidator;
import com.atlassian.webhooks.spi.WebHookListenerActionValidator;
import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import java.io.Serializable;
import javax.inject.Inject;
import javax.inject.Named;
import org.apache.commons.lang.StringUtils;
import org.osgi.framework.BundleContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Named(value="webHookListenerActionValidator")
public class WebHookListenerActionValidatorImpl
implements WebHookListenerActionValidator {
    private static final String NAME = "name";
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private final BundleContext bundleContext;
    private final EventsValidator eventsValidator;
    private final UrlValidator urlValidator;
    private final I18nResolver i18n;
    private final WebHookPluginRegistrationContainer container;

    @Inject
    public WebHookListenerActionValidatorImpl(BundleContext bundleContext, EventsValidator eventsValidator, UrlValidator urlValidator, I18nResolver i18n, WebHookPluginRegistrationContainer container) {
        this.urlValidator = urlValidator;
        this.container = container;
        this.eventsValidator = (EventsValidator)Preconditions.checkNotNull((Object)eventsValidator);
        this.bundleContext = (BundleContext)Preconditions.checkNotNull((Object)bundleContext);
        this.i18n = i18n;
    }

    @Override
    public MessageCollection validateWebHookRegistration(final PersistentWebHookListener listener) {
        return this.validateWebHookInput(listener, new Function<WebHookListenerActionValidator, MessageCollection>(){

            public MessageCollection apply(WebHookListenerActionValidator validator) {
                return validator.validateWebHookRegistration(listener);
            }
        });
    }

    @Override
    public MessageCollection validateWebHookRemoval(final PersistentWebHookListener registrationParameters) {
        return this.doValidation(new Function<WebHookListenerActionValidator, MessageCollection>(){

            public MessageCollection apply(WebHookListenerActionValidator validator) {
                return validator.validateWebHookRemoval(registrationParameters);
            }
        });
    }

    @Override
    public MessageCollection validateWebHookUpdate(final PersistentWebHookListener listener) {
        return this.validateWebHookInput(listener, new Function<WebHookListenerActionValidator, MessageCollection>(){

            public MessageCollection apply(WebHookListenerActionValidator validator) {
                return validator.validateWebHookRegistration(listener);
            }
        });
    }

    public MessageCollection validateWebHookInput(PersistentWebHookListener listener, Function<WebHookListenerActionValidator, MessageCollection> validationMethod) {
        MessageCollection.Builder messageCollectionBuilder = MessageCollection.builder();
        messageCollectionBuilder.addAll(this.eventsValidator.validate(listener));
        messageCollectionBuilder.addAll(this.urlValidator.validate(listener));
        this.validateName(listener, messageCollectionBuilder);
        messageCollectionBuilder.addAll(this.doValidation(validationMethod));
        return messageCollectionBuilder.build();
    }

    private void validateName(PersistentWebHookListener listener, MessageCollection.Builder messageCollectionBuilder) {
        if (StringUtils.isEmpty((String)listener.getName())) {
            messageCollectionBuilder.addMessage(new ErrorMessage(NAME, new Serializable[]{this.i18n.getText("webhooks.empty.field", new Serializable[]{this.i18n.getText("webhooks.name")})}), MessageCollection.Reason.VALIDATION_FAILED);
        }
    }

    private MessageCollection doValidation(Function<WebHookListenerActionValidator, MessageCollection> validationFunction) {
        MessageCollection.Builder builder = MessageCollection.builder();
        for (WebHookListenerActionValidator validator : this.container.getValidators()) {
            builder.addAll((MessageCollection)validationFunction.apply((Object)validator));
        }
        return builder.build();
    }
}

