/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.webhooks.plugin.store;

import com.atlassian.activeobjects.external.ActiveObjects;
import com.atlassian.fugue.Option;
import com.atlassian.sal.api.message.I18nResolver;
import com.atlassian.sal.api.transaction.TransactionCallback;
import com.atlassian.sal.api.user.UserKey;
import com.atlassian.sal.api.user.UserManager;
import com.atlassian.webhooks.api.register.listener.PersistentWebHookListener;
import com.atlassian.webhooks.api.register.listener.RegistrationMethod;
import com.atlassian.webhooks.api.util.Filter;
import com.atlassian.webhooks.api.util.SectionKey;
import com.atlassian.webhooks.plugin.store.WebHookListenerAO;
import com.atlassian.webhooks.spi.WebHookListenerStore;
import com.google.common.base.Function;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.Map;
import net.java.ao.DBParam;
import net.java.ao.RawEntity;
import org.apache.commons.lang.StringUtils;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class DefaultWebHookListenerStore
implements WebHookListenerStore {
    private final ActiveObjects ao;
    private final UserManager userManager;
    private final I18nResolver i18n;

    public DefaultWebHookListenerStore(ActiveObjects ao, UserManager userManager, I18nResolver i18n) {
        this.ao = ao;
        this.userManager = userManager;
        this.i18n = i18n;
    }

    @Override
    public PersistentWebHookListener addWebHook(final PersistentWebHookListener listener, final RegistrationMethod registrationMethod) {
        WebHookListenerAO webHookListenerAO = (WebHookListenerAO)this.ao.executeInTransaction((TransactionCallback)new TransactionCallback<WebHookListenerAO>(){

            public WebHookListenerAO doInTransaction() {
                WebHookListenerAO webHookListenerAO = (WebHookListenerAO)DefaultWebHookListenerStore.this.ao.create(WebHookListenerAO.class, new DBParam[]{new DBParam("LAST_UPDATED_USER", (Object)DefaultWebHookListenerStore.this.getUserKey()), new DBParam("URL", (Object)listener.getUrl()), new DBParam("LAST_UPDATED", (Object)new Date()), new DBParam("NAME", (Object)listener.getName()), new DBParam("DESCRIPTION", (Object)listener.getDescription()), new DBParam("EXCLUDE_BODY", (Object)listener.isExcludeBody()), new DBParam("FILTERS", (Object)DbParamMarshaler.marshalFilters(listener.getFilters())), new DBParam("REGISTRATION_METHOD", (Object)registrationMethod.toString()), new DBParam("EVENTS", (Object)DbParamMarshaler.marshalEvents(listener.getEvents())), new DBParam("ENABLED", (Object)listener.isEnabled())});
                webHookListenerAO.save();
                return webHookListenerAO;
            }
        });
        return DefaultWebHookListenerStore.createWebHookListenerParameters(webHookListenerAO);
    }

    @Override
    public PersistentWebHookListener updateWebHook(final PersistentWebHookListener listener) {
        WebHookListenerAO updatedWebHookListener = (WebHookListenerAO)this.ao.executeInTransaction((TransactionCallback)new TransactionCallback<WebHookListenerAO>(){

            public WebHookListenerAO doInTransaction() {
                WebHookListenerAO webHookAO = (WebHookListenerAO)DefaultWebHookListenerStore.this.ao.get(WebHookListenerAO.class, listener.getId().get());
                if (webHookAO == null) {
                    throw new IllegalArgumentException(DefaultWebHookListenerStore.this.i18n.getText("webhooks.invalid.webhook.id"));
                }
                webHookAO.setName(listener.getName());
                webHookAO.setUrl(listener.getUrl());
                webHookAO.setDescription(listener.getDescription());
                webHookAO.setEvents(DbParamMarshaler.marshalEvents(listener.getEvents()));
                webHookAO.setEnabled(listener.isEnabled());
                webHookAO.setLastUpdatedUser(DefaultWebHookListenerStore.this.getUserKey());
                webHookAO.setLastUpdated(new Date());
                webHookAO.setExcludeBody(listener.isExcludeBody());
                webHookAO.setFilters(DbParamMarshaler.marshalFilters(listener.getFilters()));
                webHookAO.save();
                return webHookAO;
            }
        });
        return DefaultWebHookListenerStore.createWebHookListenerParameters(updatedWebHookListener);
    }

    @Override
    public Option<PersistentWebHookListener> getWebHook(final int id) {
        return (Option)this.ao.executeInTransaction((TransactionCallback)new TransactionCallback<Option<PersistentWebHookListener>>(){

            public Option<PersistentWebHookListener> doInTransaction() {
                return Option.option((Object)DefaultWebHookListenerStore.createWebHookListenerParameters((WebHookListenerAO)DefaultWebHookListenerStore.this.ao.get(WebHookListenerAO.class, (Object)id)));
            }
        });
    }

    @Override
    public void removeWebHook(final int id) {
        this.ao.executeInTransaction((TransactionCallback)new TransactionCallback<Object>(){

            public Object doInTransaction() {
                WebHookListenerAO webHookListenerAO = (WebHookListenerAO)DefaultWebHookListenerStore.this.ao.get(WebHookListenerAO.class, (Object)id);
                if (webHookListenerAO == null) {
                    throw new IllegalArgumentException(DefaultWebHookListenerStore.this.i18n.getText("webhooks.invalid.webhook.id"));
                }
                DefaultWebHookListenerStore.this.ao.delete(new RawEntity[]{webHookListenerAO});
                return webHookListenerAO;
            }
        });
    }

    @Override
    public Collection<PersistentWebHookListener> getAllWebHooks() {
        return Lists.newArrayList((Iterable)Iterables.transform((Iterable)((Iterable)this.ao.executeInTransaction((TransactionCallback)new TransactionCallback<Collection<WebHookListenerAO>>(){

            public Collection<WebHookListenerAO> doInTransaction() {
                return Arrays.asList(DefaultWebHookListenerStore.this.ao.find(WebHookListenerAO.class));
            }
        })), (Function)new Function<WebHookListenerAO, PersistentWebHookListener>(){

            public PersistentWebHookListener apply(WebHookListenerAO webhookDao) {
                return DefaultWebHookListenerStore.createWebHookListenerParameters(webhookDao);
            }
        }));
    }

    private static PersistentWebHookListener createWebHookListenerParameters(WebHookListenerAO webHookListenerAO) {
        return PersistentWebHookListener.existing(webHookListenerAO.getID()).addWebHookIds(DbParamMarshaler.unmarshalEvents(webHookListenerAO.getEvents())).addFilters(DbParamMarshaler.unmarshalFilters(webHookListenerAO.getFilters())).setEnabled(webHookListenerAO.isEnabled()).setExcludeBody(webHookListenerAO.isExcludeBody()).setLastUpdated(webHookListenerAO.getLastUpdated()).setLastUpdatedByUser(webHookListenerAO.getLastUpdatedUser()).setListenerName(webHookListenerAO.getName()).setUrl(webHookListenerAO.getUrl()).setDescription(webHookListenerAO.getDescription()).build();
    }

    private String getUserKey() {
        UserKey userKey = this.userManager.getRemoteUserKey();
        return userKey != null ? userKey.getStringValue() : "";
    }

    public static class DbParamMarshaler {
        public static String marshalEvents(Iterable<String> events) {
            return events != null ? new JSONArray(Lists.newArrayList(events)).toString() : "";
        }

        public static String marshalFilters(Map<SectionKey, Filter> params) {
            Map map = Maps.transformValues(params, (Function)new Function<Filter, String>(){

                public String apply(Filter input) {
                    return input.getValue();
                }
            });
            return new JSONObject(map).toString();
        }

        public static Collection<String> unmarshalEvents(String events) {
            try {
                JSONArray jsonArray = events != null ? new JSONArray(events) : new JSONArray();
                ImmutableList.Builder builder = ImmutableList.builder();
                for (int i = 0; i < jsonArray.length(); ++i) {
                    builder.add((Object)jsonArray.getString(i));
                }
                return builder.build();
            }
            catch (JSONException e) {
                throw new RuntimeException(e);
            }
        }

        public static Map<String, String> unmarshalFilters(String parameters) {
            try {
                JSONObject jsonObject = StringUtils.isNotBlank((String)parameters) ? new JSONObject(parameters) : new JSONObject();
                ImmutableMap.Builder builder = ImmutableMap.builder();
                String[] names = JSONObject.getNames(jsonObject);
                if (names != null) {
                    for (String key : names) {
                        builder.put((Object)key, (Object)jsonObject.getString(key));
                    }
                }
                return builder.build();
            }
            catch (JSONException e) {
                throw new RuntimeException(e);
            }
        }
    }
}

