/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.webhooks.plugin.module;

import com.atlassian.webhooks.api.publish.WebHookEvent;
import com.atlassian.webhooks.api.register.RegisteredWebHookEvent;
import com.atlassian.webhooks.api.register.WebHookEventGroup;
import com.atlassian.webhooks.api.register.WebHookEventSection;
import com.atlassian.webhooks.api.register.WebHookPluginRegistration;
import com.atlassian.webhooks.api.util.SectionKey;
import com.atlassian.webhooks.plugin.module.ModuleKey;
import com.atlassian.webhooks.plugin.module.WebHookKey;
import com.google.common.base.Function;
import com.google.common.base.Predicate;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.common.collect.Maps;
import com.google.common.collect.SetMultimap;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WebHookRegistry {
    private final Map<WebHookKey, RegisteredWebHookEvent<?>> registrationsByWebHookKey = Maps.newConcurrentMap();
    private final SetMultimap<Class, RegisteredWebHookEvent> registrationsByEvent = HashMultimap.create();
    private final Map<ModuleKey, Set<RegisteredWebHookEvent>> registrationsByModuleKey = Maps.newConcurrentMap();
    private final Map<WebHookKey, SectionKey> sectionsByWebHookKey = Maps.newConcurrentMap();
    private final ReadWriteLock lock = new ReentrantReadWriteLock();
    private final Logger logger = LoggerFactory.getLogger(this.getClass());

    public Set<WebHookKey> getWebHookIds() {
        return ImmutableSet.copyOf(this.registrationsByWebHookKey.keySet());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<WebHookEvent> getWebHooks(final Object event) {
        try {
            if (!this.lock.readLock().tryLock(5L, TimeUnit.SECONDS)) {
                throw new IllegalStateException("Could not acquire read lock to WebHooks registrations");
            }
            Map webHookRegistrationByEvent = Maps.filterKeys((Map)this.registrationsByEvent.asMap(), (Predicate)new Predicate<Class>(){

                public boolean apply(Class eventClass) {
                    return eventClass.isInstance(event);
                }
            });
            Iterable webHookRegistrations = Iterables.concat(webHookRegistrationByEvent.values());
            ImmutableList immutableList = ImmutableList.copyOf((Iterable)Iterables.transform((Iterable)webHookRegistrations, (Function)new Function<RegisteredWebHookEvent, WebHookEvent>(){

                public WebHookEvent apply(RegisteredWebHookEvent registration) {
                    return new WebHookEvent<Object>(registration.getId(), event, registration.getEventMatcher());
                }
            }));
            return immutableList;
        }
        catch (InterruptedException e) {
            this.logger.error("There was an error while reading existing WebHooks events", (Throwable)e);
            List<WebHookEvent> list = Collections.emptyList();
            return list;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void add(ModuleKey moduleKey, WebHookPluginRegistration pluginRegistration) {
        try {
            if (!this.lock.writeLock().tryLock(30L, TimeUnit.SECONDS)) {
                throw new IllegalStateException("Could not acquire write lock to WebHooks registrations");
            }
            for (WebHookEventSection section : pluginRegistration.getSections()) {
                for (WebHookEventGroup group : section.getGroups()) {
                    for (RegisteredWebHookEvent event : group.getEvents()) {
                        if (event.getEventClass() != null) {
                            this.registrationsByEvent.put(event.getEventClass(), (Object)event);
                        }
                        this.registrationsByWebHookKey.put(new WebHookKey(event.getId()), event);
                        this.sectionsByWebHookKey.put(new WebHookKey(event.getId()), new SectionKey(section.getKey()));
                    }
                }
            }
            this.registrationsByModuleKey.put(moduleKey, (Set<RegisteredWebHookEvent>)ImmutableSet.copyOf(pluginRegistration.getRegistrations()));
        }
        catch (InterruptedException e) {
            this.logger.error("Error when adding new WebHooks events", (Throwable)e);
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void remove(ModuleKey moduleKey) {
        try {
            if (!this.lock.writeLock().tryLock(30L, TimeUnit.SECONDS)) {
                throw new IllegalStateException("Could not acquire write lock to WebHooks registrations");
            }
            Set<RegisteredWebHookEvent> registrations = this.registrationsByModuleKey.remove(moduleKey);
            Iterator<Object> i = this.registrationsByEvent.values().iterator();
            while (i.hasNext()) {
                if (!registrations.contains(i.next())) continue;
                i.remove();
            }
            i = this.registrationsByWebHookKey.values().iterator();
            while (i.hasNext()) {
                if (!registrations.contains(i.next())) continue;
                i.remove();
            }
            for (RegisteredWebHookEvent event : registrations) {
                this.sectionsByWebHookKey.remove(new WebHookKey(event.getId()));
            }
        }
        catch (InterruptedException e) {
            this.logger.error("Error when removing existing WebHooks events", (Throwable)e);
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    public SectionKey sectionOf(String id) {
        return this.sectionsByWebHookKey.get(new WebHookKey(id));
    }
}

