/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.webhooks.plugin;

import com.atlassian.fugue.Effect;
import com.atlassian.httpclient.api.HttpClient;
import com.atlassian.httpclient.api.Request;
import com.atlassian.httpclient.api.Response;
import com.atlassian.httpclient.api.ResponseTransformation;
import com.atlassian.sal.api.user.UserManager;
import com.atlassian.sal.api.user.UserProfile;
import com.atlassian.uri.Uri;
import com.atlassian.uri.UriBuilder;
import com.atlassian.webhooks.api.publish.WebHookEvent;
import com.atlassian.webhooks.api.register.listener.WebHookListener;
import com.atlassian.webhooks.api.register.listener.WebHookListenerOrigin;
import com.atlassian.webhooks.api.register.listener.WebHookListenerRegistrationDetails;
import com.atlassian.webhooks.plugin.PublishTask;
import com.atlassian.webhooks.plugin.PublishTaskFactory;
import com.atlassian.webhooks.plugin.ThrottlingLogger;
import com.atlassian.webhooks.plugin.TokenBucket;
import com.atlassian.webhooks.plugin.module.WebHookEventSerializer;
import com.atlassian.webhooks.plugin.uri.UriVariablesResolver;
import com.atlassian.webhooks.spi.RequestSigner2;
import com.google.common.base.Function;
import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import java.net.URI;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class PublishTaskFactoryImpl
implements PublishTaskFactory {
    private static final int ONE_MINUTE = 60000;
    private final HttpClient httpClient;
    private final RequestSigner2 requestSigner;
    private final UserManager userManager;
    private final UriVariablesResolver uriVariablesResolver;
    private final WebHookEventSerializer webHookEventSerializer;

    public PublishTaskFactoryImpl(HttpClient httpClient, RequestSigner2 requestSigner, UserManager userManager, UriVariablesResolver uriVariablesResolver, WebHookEventSerializer webHookEventSerializer) {
        this.webHookEventSerializer = webHookEventSerializer;
        this.httpClient = (HttpClient)Preconditions.checkNotNull((Object)httpClient);
        this.requestSigner = (RequestSigner2)Preconditions.checkNotNull((Object)requestSigner);
        this.userManager = (UserManager)Preconditions.checkNotNull((Object)userManager);
        this.uriVariablesResolver = (UriVariablesResolver)Preconditions.checkNotNull((Object)uriVariablesResolver);
    }

    @Override
    public PublishTask getPublishTask(WebHookEvent webHookEvent, WebHookListener listener) {
        return new PublishTaskImpl(this.httpClient, this.requestSigner, listener, this.getListenerUri(webHookEvent, listener), this.userManager.getRemoteUser(), this.getEventBody(webHookEvent, listener));
    }

    private String getEventBody(WebHookEvent webHookEvent, WebHookListener listener) {
        return this.webHookEventSerializer.serialize(webHookEvent, listener);
    }

    private URI getListenerUri(WebHookEvent webHookEvent, WebHookListener listener) {
        return this.uriVariablesResolver.resolve(listener, webHookEvent);
    }

    static final class PublishTaskImpl
    implements PublishTask {
        private final Logger logger = LoggerFactory.getLogger(this.getClass());
        private final ThrottlingLogger throttlingLogger = new ThrottlingLogger(this.logger, new TokenBucket(1L, 60000L, 5L));
        private final HttpClient httpClient;
        private final RequestSigner2 requestSigner;
        private final WebHookListener listener;
        private final URI uri;
        private final String body;
        private final Optional<UserProfile> user;

        PublishTaskImpl(HttpClient httpClient, RequestSigner2 requestSigner, WebHookListener listener, URI uri, UserProfile user, String body) {
            this.httpClient = (HttpClient)Preconditions.checkNotNull((Object)httpClient);
            this.requestSigner = (RequestSigner2)Preconditions.checkNotNull((Object)requestSigner);
            this.listener = (WebHookListener)Preconditions.checkNotNull((Object)listener);
            this.uri = (URI)Preconditions.checkNotNull((Object)uri);
            this.user = Optional.ofNullable(user);
            this.body = (String)Preconditions.checkNotNull((Object)body);
        }

        @Override
        public void run() {
            URI uri = this.getUri();
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("Posting to web hook at '{}', body is:\n{}\n", (Object)uri, (Object)this.body);
            }
            Request.Builder request = Strings.isNullOrEmpty((String)this.body) ? this.httpClient.newRequest(uri) : this.httpClient.newRequest(uri, "application/json", this.body);
            this.setRequestAttributes(request);
            this.requestSigner.sign(uri, this.user, this.listener.getRegistrationDetails(), request);
            request.post().transform(this.logResult());
        }

        private ResponseTransformation<Object> logResult() {
            return (ResponseTransformation)this.httpClient.transformation().successful((Function)new Function<Response, Object>(){

                public Object apply(Response response) {
                    PublishTaskImpl.this.logger.debug("WebHook successfully sent");
                    return null;
                }
            }).clientError(this.logError("Client error")).serverError(this.logError("Server error")).build();
        }

        private Function<Response, Void> logError(final String errorName) {
            return new Function<Response, Void>(){

                public Void apply(final Response response) {
                    return PublishTaskImpl.this.throttlingLogger.use(new Effect<Logger>(){

                        public void apply(Logger logger) {
                            logger.warn(errorName + " - {} when posting to web hook at '{}'\n", (Object)response.getStatusCode(), (Object)PublishTaskImpl.this.uri);
                            logger.debug("Body is {}\n", (Object)PublishTaskImpl.this.body);
                        }
                    });
                }
            };
        }

        private void setRequestAttributes(Request.Builder request) {
            request.setAttribute("purpose", "web-hook-notification");
            if (this.listenerPluginKey() != null) {
                request.setAttribute("pluginKey", this.listenerPluginKey());
            }
        }

        private String listenerPluginKey() {
            return this.listener.getRegistrationDetails().getOrigin() == WebHookListenerOrigin.MODULE_DESCRIPTOR ? ((WebHookListenerRegistrationDetails.ModuleDescriptorRegistrationDetails)this.listener.getRegistrationDetails().getModuleDescriptorDetails().get()).getPluginKey() : null;
        }

        URI getUri() {
            Uri parsedUri = Uri.fromJavaUri(this.uri);
            UriBuilder uriBuilder = new UriBuilder().setScheme(parsedUri.getScheme()).setAuthority(parsedUri.getAuthority()).setPath(parsedUri.getPath()).setQuery(parsedUri.getQuery());
            if (this.user.isPresent()) {
                uriBuilder = uriBuilder.addQueryParameter("user_id", this.user.get().getUsername()).addQueryParameter("user_key", this.user.get().getUserKey().getStringValue());
            }
            return uriBuilder.toUri().toJavaUri();
        }

        public String toString() {
            Objects.ToStringHelper toStringHelper = Objects.toStringHelper(PublishTask.class).add("listenerKey", (Object)this.listener).add("uri", (Object)this.uri).add("body", (Object)this.body);
            if (this.user.isPresent()) {
                toStringHelper.add("userName", (Object)this.user.get().getUsername()).add("userKey", (Object)this.user.get().getUserKey().getStringValue());
            }
            return toStringHelper.toString();
        }
    }
}

