/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.webhooks.plugin;

import com.atlassian.webhooks.api.publish.WebHookEvent;
import com.atlassian.webhooks.api.register.listener.PersistentWebHookListener;
import com.atlassian.webhooks.api.register.listener.WebHookListener;
import com.atlassian.webhooks.api.register.listener.WebHookListenerService;
import com.atlassian.webhooks.api.util.ConsiderAllListeners;
import com.atlassian.webhooks.plugin.WebHookListenerProvider;
import com.atlassian.webhooks.plugin.module.WebHookPluginRegistrationContainer;
import com.google.common.base.Function;
import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.collect.Iterables;
import org.apache.commons.lang.StringUtils;

public class PersistentWebHookListenerProvider
implements WebHookListenerProvider {
    private final WebHookListenerService webHookListenerService;
    private final WebHookPluginRegistrationContainer webHookContainer;

    public PersistentWebHookListenerProvider(WebHookListenerService webHookListenerService, WebHookPluginRegistrationContainer webHookContainer) {
        this.webHookContainer = webHookContainer;
        this.webHookListenerService = (WebHookListenerService)Preconditions.checkNotNull((Object)webHookListenerService);
    }

    @Override
    public Iterable<WebHookListener> getListeners(final WebHookEvent webHookEvent) {
        Iterable enabledWebHookListeners = Iterables.filter(this.webHookListenerService.getAllWebHookListeners(), (Predicate)new Predicate<PersistentWebHookListener>(){

            public boolean apply(PersistentWebHookListener webHookListenerParameters) {
                return webHookListenerParameters.isEnabled() && PersistentWebHookListenerProvider.this.preFilter(webHookEvent, webHookListenerParameters);
            }
        });
        return Iterables.transform((Iterable)enabledWebHookListeners, (Function)new Function<PersistentWebHookListener, WebHookListener>(){

            public WebHookListener apply(PersistentWebHookListener registeredListener) {
                return WebHookListener.fromPersistentStore((Integer)registeredListener.getId().get(), registeredListener.getName(), (Optional<String>)(StringUtils.isEmpty((String)registeredListener.getLastUpdatedByUser()) ? Optional.absent() : Optional.of((Object)registeredListener.getLastUpdatedByUser()))).to(registeredListener.getUrl()).excludeBody(registeredListener.isExcludeBody()).withFilter(registeredListener.getFilterFor(PersistentWebHookListenerProvider.this.webHookContainer.getWebHookRegistry().sectionOf(webHookEvent.getId()))).build();
            }
        });
    }

    private boolean preFilter(WebHookEvent webHookEvent, PersistentWebHookListener listener) {
        boolean skipFiltering = webHookEvent.getEventMatcher().getClass().isAnnotationPresent(ConsiderAllListeners.class);
        return skipFiltering || Iterables.contains(listener.getEvents(), (Object)webHookEvent.getId());
    }
}

