/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.webhooks.api.util;

import com.atlassian.annotations.PublicApi;
import com.atlassian.httpclient.api.HttpStatus;
import com.atlassian.sal.api.message.Message;
import com.atlassian.webhooks.api.util.ErrorMessage;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import javax.annotation.concurrent.Immutable;

@PublicApi
@Immutable
public final class MessageCollection {
    private static final MessageCollection EMPTY_MESSAGE_COLLECTION = new MessageCollection((List<Message>)ImmutableList.of(), (Set<Reason>)ImmutableSet.of());
    private final List<Message> messages;
    private final Set<Reason> reasons;

    public static MessageCollection empty() {
        return EMPTY_MESSAGE_COLLECTION;
    }

    public static MessageCollection of(String message, Reason reason) {
        return MessageCollection.builder().addMessage(message, reason).build();
    }

    private MessageCollection(List<Message> messages, Set<Reason> reasons) {
        this.messages = messages;
        this.reasons = reasons;
    }

    public static Builder builder() {
        return new Builder();
    }

    public boolean isEmpty() {
        return this.messages.isEmpty();
    }

    public List<Message> getMessages() {
        return this.messages;
    }

    public Set<Reason> getReasons() {
        return this.reasons;
    }

    public static enum Reason {
        NOT_FOUND(HttpStatus.NOT_FOUND),
        NOT_LOGGED_IN(HttpStatus.UNAUTHORIZED),
        FORBIDDEN(HttpStatus.FORBIDDEN),
        VALIDATION_FAILED(HttpStatus.BAD_REQUEST),
        CONFLICT(HttpStatus.CONFLICT);

        private HttpStatus httpStatusCode;

        private Reason(HttpStatus httpStatusCode) {
            this.httpStatusCode = httpStatusCode;
        }

        public int getHttpStatusCode() {
            return this.httpStatusCode.code;
        }

        public static Reason getWorstReason(Collection<Reason> reasons) {
            if (reasons.contains((Object)NOT_LOGGED_IN)) {
                return NOT_LOGGED_IN;
            }
            if (reasons.contains((Object)FORBIDDEN)) {
                return FORBIDDEN;
            }
            if (reasons.contains((Object)NOT_FOUND)) {
                return NOT_FOUND;
            }
            if (reasons.contains((Object)VALIDATION_FAILED)) {
                return VALIDATION_FAILED;
            }
            if (reasons.contains((Object)CONFLICT)) {
                return CONFLICT;
            }
            return null;
        }
    }

    public static class Builder {
        private final List<Message> messages = Lists.newArrayList();
        private final Set<Reason> reasons = Sets.newHashSet();

        public Builder addMessage(String message, Reason reason) {
            return this.addMessage(new ErrorMessage(message), reason);
        }

        public Builder addMessage(Message errorMessage, Reason reason) {
            return this.addAll(Lists.newArrayList((Object[])new Message[]{errorMessage}), Sets.newHashSet((Object[])new Reason[]{reason}));
        }

        public Builder addAll(List<Message> errorMessages, Set<Reason> reasons) {
            this.messages.addAll(errorMessages);
            this.reasons.addAll(reasons);
            return this;
        }

        public Builder addAll(MessageCollection msgCollection) {
            this.messages.addAll(msgCollection.getMessages());
            this.reasons.addAll(msgCollection.getReasons());
            return this;
        }

        public MessageCollection build() {
            return new MessageCollection((List)ImmutableList.copyOf(this.messages), (Set)ImmutableSet.copyOf(this.reasons));
        }
    }
}

