/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.webhooks.api.util;

import com.atlassian.annotations.PublicApi;
import com.atlassian.webhooks.api.register.listener.WebHookListener;
import com.atlassian.webhooks.spi.EventMatcher;
import com.google.common.base.Predicate;
import com.google.common.collect.Iterables;
import java.util.Arrays;

@PublicApi
public final class EventMatchers {
    public static final EventMatcher<Object> ALWAYS_TRUE = new EventMatcher<Object>(){

        @Override
        public boolean matches(Object event, WebHookListener listenerParameters) {
            return true;
        }
    };
    public static final EventMatcher<Object> ALWAYS_FALSE = new EventMatcher<Object>(){

        @Override
        public boolean matches(Object event, WebHookListener listenerParameters) {
            return false;
        }
    };

    private EventMatchers() {
    }

    public static <T> EventMatcher<T> and(final Iterable<EventMatcher<T>> matchers) {
        return new EventMatcher<T>(){

            @Override
            public boolean matches(final T event, final WebHookListener listener) {
                return Iterables.all((Iterable)matchers, (Predicate)new Predicate<EventMatcher<T>>(){

                    public boolean apply(EventMatcher<T> matcher) {
                        return matcher.matches(event, listener);
                    }
                });
            }
        };
    }

    public static <T> EventMatcher<T> and(EventMatcher<T> ... matchers) {
        return EventMatchers.and(Arrays.asList(matchers));
    }

    public static EventMatcher<Object> or(final Iterable<EventMatcher<Object>> matchers) {
        return new EventMatcher<Object>(){

            @Override
            public boolean matches(final Object event, final WebHookListener listener) {
                return Iterables.any((Iterable)matchers, (Predicate)new Predicate<EventMatcher<Object>>(){

                    public boolean apply(EventMatcher<Object> matcher) {
                        return matcher.matches(event, listener);
                    }
                });
            }
        };
    }

    public static EventMatcher<Object> or(EventMatcher<Object> ... matchers) {
        return EventMatchers.or(Arrays.asList(matchers));
    }
}

