/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.webhooks.api.register.listener;

import com.atlassian.annotations.PublicApi;
import com.atlassian.fugue.Option;
import com.atlassian.webhooks.api.register.listener.PersistentWebHookListener;
import com.atlassian.webhooks.api.util.MessageCollection;
import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import javax.annotation.concurrent.Immutable;

@PublicApi
@Immutable
public class WebHookListenerServiceResponse {
    private final MessageCollection messageCollection;
    private final Option<PersistentWebHookListener> registeredListener;

    private WebHookListenerServiceResponse(MessageCollection messageCollection, Option<PersistentWebHookListener> webHookListenerParameters) {
        this.messageCollection = (MessageCollection)Preconditions.checkNotNull((Object)messageCollection);
        this.registeredListener = (Option)Preconditions.checkNotNull(webHookListenerParameters);
    }

    public MessageCollection getMessageCollection() {
        return this.messageCollection;
    }

    public Option<PersistentWebHookListener> getRegisteredListener() {
        return this.registeredListener;
    }

    public static WebHookListenerServiceResponse ok(PersistentWebHookListener registeredListener) {
        return new WebHookListenerServiceResponse(MessageCollection.empty(), (Option<PersistentWebHookListener>)Option.some((Object)registeredListener));
    }

    public static WebHookListenerServiceResponse error(MessageCollection messageCollection) {
        return new WebHookListenerServiceResponse(messageCollection, (Option<PersistentWebHookListener>)Option.none(PersistentWebHookListener.class));
    }

    public <T> T fold(Function<MessageCollection, T> onError, Function<PersistentWebHookListener, T> onSuccess) {
        if (this.messageCollection.isEmpty() && this.registeredListener.isDefined()) {
            return (T)onSuccess.apply(this.registeredListener.get());
        }
        if (!this.messageCollection.isEmpty()) {
            return (T)onError.apply((Object)this.messageCollection);
        }
        throw new IllegalStateException();
    }
}

