/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.webhooks.api.register.listener;

import com.atlassian.annotations.PublicApi;
import com.atlassian.fugue.Option;
import com.atlassian.webhooks.api.register.listener.WebHookListenerOrigin;
import com.google.common.base.Objects;
import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.Immutable;

@PublicApi
@Immutable
public final class WebHookListenerRegistrationDetails {
    private final ModuleDescriptorRegistrationDetails moduleDescriptorDetails;
    private final PersistentStoreRegistrationDetails persistentStoreDetails;
    private final WebHookListenerOrigin origin;

    private WebHookListenerRegistrationDetails(@Nullable ModuleDescriptorRegistrationDetails moduleDescriptorDetails, @Nullable PersistentStoreRegistrationDetails persistentStoreDetails, WebHookListenerOrigin origin) {
        this.moduleDescriptorDetails = moduleDescriptorDetails;
        this.persistentStoreDetails = persistentStoreDetails;
        this.origin = origin;
    }

    public static WebHookListenerRegistrationDetails persistentStore(@Nonnull Integer listenerId, @Nonnull String listenerName) {
        return WebHookListenerRegistrationDetails.persistentStore(listenerId, listenerName, null);
    }

    public static WebHookListenerRegistrationDetails persistentStore(@Nonnull Integer listenerId, @Nonnull String listenerName, Optional<String> lastUpdateUser) {
        return new WebHookListenerRegistrationDetails(null, new PersistentStoreRegistrationDetails((Integer)Preconditions.checkNotNull((Object)listenerId), (String)Preconditions.checkNotNull((Object)listenerName), (Optional)Preconditions.checkNotNull(lastUpdateUser)), WebHookListenerOrigin.PERSISTENT_STORE);
    }

    public static WebHookListenerRegistrationDetails moduleDescriptor(@Nonnull String plugninKey) {
        return new WebHookListenerRegistrationDetails(new ModuleDescriptorRegistrationDetails((String)Preconditions.checkNotNull((Object)plugninKey)), null, WebHookListenerOrigin.MODULE_DESCRIPTOR);
    }

    public Option<ModuleDescriptorRegistrationDetails> getModuleDescriptorDetails() {
        return Option.option((Object)this.moduleDescriptorDetails);
    }

    public Option<PersistentStoreRegistrationDetails> getPersistentStoreDetails() {
        return Option.option((Object)this.persistentStoreDetails);
    }

    public WebHookListenerOrigin getOrigin() {
        return this.origin;
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.moduleDescriptorDetails, this.persistentStoreDetails, this.origin});
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        WebHookListenerRegistrationDetails other = (WebHookListenerRegistrationDetails)obj;
        return Objects.equal((Object)this.moduleDescriptorDetails, (Object)other.moduleDescriptorDetails) && Objects.equal((Object)this.persistentStoreDetails, (Object)other.persistentStoreDetails) && Objects.equal((Object)((Object)this.origin), (Object)((Object)other.origin));
    }

    public static final class PersistentStoreRegistrationDetails {
        private final Integer id;
        private final String name;
        private final Optional<String> lastUpdatedUserKey;

        private PersistentStoreRegistrationDetails(Integer id, String name, Optional<String> lastUpdatedUserKey) {
            this.id = id;
            this.name = name;
            this.lastUpdatedUserKey = lastUpdatedUserKey;
        }

        public Integer getId() {
            return this.id;
        }

        public Optional<String> getLastUpdatedUserKey() {
            return this.lastUpdatedUserKey;
        }

        public String getName() {
            return this.name;
        }

        public int hashCode() {
            return Objects.hashCode((Object[])new Object[]{this.id, this.lastUpdatedUserKey, this.name});
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null || this.getClass() != obj.getClass()) {
                return false;
            }
            PersistentStoreRegistrationDetails other = (PersistentStoreRegistrationDetails)obj;
            return Objects.equal((Object)this.id, (Object)other.id) && Objects.equal(this.lastUpdatedUserKey, other.lastUpdatedUserKey) && Objects.equal((Object)this.name, (Object)other.name);
        }
    }

    public static final class ModuleDescriptorRegistrationDetails {
        private final String pluginKey;

        private ModuleDescriptorRegistrationDetails(String pluginKey) {
            this.pluginKey = (String)Preconditions.checkNotNull((Object)pluginKey);
        }

        public String getPluginKey() {
            return this.pluginKey;
        }

        public int hashCode() {
            return this.pluginKey.hashCode();
        }

        public boolean equals(Object obj) {
            return obj instanceof ModuleDescriptorRegistrationDetails && ((ModuleDescriptorRegistrationDetails)obj).getPluginKey().equals(this.getPluginKey());
        }
    }
}

