/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.webhooks.api.register.listener;

import com.atlassian.annotations.PublicApi;
import com.atlassian.webhooks.api.register.listener.WebHookListenerParameters;
import com.atlassian.webhooks.api.register.listener.WebHookListenerRegistrationDetails;
import com.google.common.base.Objects;
import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import javax.annotation.Nonnull;
import javax.annotation.concurrent.Immutable;

@PublicApi
@Immutable
public final class WebHookListener {
    private final WebHookListenerRegistrationDetails registrationDetails;
    private final WebHookListenerParameters params;

    private WebHookListener(WebHookListenerRegistrationDetails registrationDetails, WebHookListenerParameters params) {
        this.registrationDetails = registrationDetails;
        this.params = params;
    }

    public WebHookListenerRegistrationDetails getRegistrationDetails() {
        return this.registrationDetails;
    }

    public WebHookListenerParameters getParameters() {
        return this.params;
    }

    public static Builder fromModuleDescriptor(@Nonnull String pluginKey) {
        return new Builder(WebHookListenerRegistrationDetails.moduleDescriptor(pluginKey));
    }

    public static Builder fromPersistentStore(Integer id, String listenerName) {
        return new Builder(WebHookListenerRegistrationDetails.persistentStore(id, listenerName, (Optional<String>)Optional.absent()));
    }

    public static Builder fromPersistentStore(Integer id, String listenerName, Optional<String> lastUpdatedUserKey) {
        return new Builder(WebHookListenerRegistrationDetails.persistentStore(id, listenerName, lastUpdatedUserKey));
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.registrationDetails, this.params});
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        WebHookListener other = (WebHookListener)obj;
        return Objects.equal((Object)this.registrationDetails, (Object)other.registrationDetails) && Objects.equal((Object)this.params, (Object)other.params);
    }

    public static class Builder {
        private final WebHookListenerRegistrationDetails registrationDetails;
        private String url;
        private boolean excludeBody = false;
        private String filter = "";

        private Builder(WebHookListenerRegistrationDetails registrationDetails) {
            this.registrationDetails = registrationDetails;
        }

        public Builder to(String url) {
            this.url = url;
            return this;
        }

        public WebHookListener build() {
            Preconditions.checkState((this.url != null ? 1 : 0) != 0);
            return new WebHookListener(this.registrationDetails, new WebHookListenerParameters(this.url, this.filter, this.excludeBody));
        }

        public Builder excludeBody() {
            this.excludeBody = true;
            return this;
        }

        public Builder excludeBody(boolean exclude) {
            this.excludeBody = exclude;
            return this;
        }

        public Builder withFilter(String filter) {
            this.filter = filter;
            return this;
        }
    }
}

