/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.webhooks.api.register;

import com.atlassian.annotations.PublicApi;
import com.atlassian.webhooks.api.register.RegisteredWebHookEvent;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.concurrent.Immutable;

@PublicApi
@Immutable
public class WebHookEventGroup {
    private final String nameI18nKey;
    private final List<RegisteredWebHookEvent> events;

    private WebHookEventGroup(String nameI18nKey, Iterable<RegisteredWebHookEvent> events) {
        this.nameI18nKey = nameI18nKey;
        this.events = ImmutableList.copyOf(events);
    }

    public static Builder builder() {
        return new Builder();
    }

    public String getNameI18nKey() {
        return this.nameI18nKey;
    }

    public List<RegisteredWebHookEvent> getEvents() {
        return this.events;
    }

    @PublicApi
    public static class Builder {
        private String nameI18nKey;
        private final Set<RegisteredWebHookEvent> events = new LinkedHashSet<RegisteredWebHookEvent>();

        public Builder nameI18nKey(String nameI18nKey) {
            this.nameI18nKey = nameI18nKey;
            return this;
        }

        public Builder addEvent(@Nonnull RegisteredWebHookEvent event) {
            this.events.add((RegisteredWebHookEvent)Preconditions.checkNotNull((Object)event));
            return this;
        }

        public WebHookEventGroup build() {
            return new WebHookEventGroup(this.nameI18nKey, this.events);
        }
    }
}

