UPM.define('AddonWatchingModel',
    [
        'jquery',
        'brace'
    ],
    function($, Brace) {

    "use strict";

    /**
     * Represents the "watching" status of an add-on (whether the user wants to be notified of Marketplace
     * updates for the add-on).  This is loaded separately from the add-on model by AddonModel.loadWatchingModel().
     */
    return Brace.Model.extend({

        namedAttributes: [
            'addon',
            'links',
            'watching'
        ],

        updateWatching: function(watching) {
            var me = this;
            if (watching !== this.getWatching()) {
                return $.ajax({
                    url: this.get('links').self,
                    type: watching ? 'post' : 'delete',
                    dataType: watching ? 'json' : 'text'
                }).done(function() {
                    me.set('watching', watching);
                }).promise();
            }
        }
    });
});
