/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.plugin.spring.scanner.runtime.impl;

import java.beans.PropertyDescriptor;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.Dictionary;
import java.util.Enumeration;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeansException;
import org.springframework.beans.PropertyValues;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.config.DestructionAwareBeanPostProcessor;
import org.springframework.beans.factory.config.InstantiationAwareBeanPostProcessor;

public class DevModeBeanInitialisationLoggerBeanPostProcessor
implements InstantiationAwareBeanPostProcessor,
InitializingBean,
DestructionAwareBeanPostProcessor,
DisposableBean {
    private static final boolean isDevMode = Boolean.parseBoolean(System.getProperty("atlassian.dev.mode", "false"));
    private volatile Logger log;
    private final BundleContext bundleContext;

    public DevModeBeanInitialisationLoggerBeanPostProcessor(BundleContext bundleContext) {
        this.bundleContext = bundleContext;
    }

    public Object postProcessBeforeInitialization(Object bean, String beanName) throws BeansException {
        return bean;
    }

    public Object postProcessAfterInitialization(Object bean, String beanName) throws BeansException {
        this.logBeanDetail("AfterInitialisation", bean.getClass(), beanName);
        return bean;
    }

    public Object postProcessBeforeInstantiation(Class beanClass, String beanName) throws BeansException {
        this.logBeanDetail("BeforeInstantiation", beanClass, beanName);
        return null;
    }

    public boolean postProcessAfterInstantiation(Object bean, String beanName) throws BeansException {
        return true;
    }

    public PropertyValues postProcessPropertyValues(PropertyValues pvs, PropertyDescriptor[] pds, Object bean, String beanName) throws BeansException {
        return pvs;
    }

    public void postProcessBeforeDestruction(Object bean, String beanName) throws BeansException {
        this.logBeanDetail("BeforeDestruction", bean.getClass(), beanName);
    }

    private void logBeanDetail(String stage, Class beanClass, String beanName) {
        if (this.log.isDebugEnabled()) {
            this.log.debug(String.format("%s [bean=%s, type=%s]", stage, beanName, beanClass.getName()));
        }
    }

    public void afterPropertiesSet() throws Exception {
        this.log = LoggerFactory.getLogger((String)this.getLoggerName());
        Bundle bundle = this.bundle();
        if (isDevMode) {
            String loggerName = this.getLoggerName();
            String msg = String.format("\nSpring context started for bundle : %s id(%d) v(%s) %s\n\nIf you want to debug the Spring wiring of your code then set a DEBUG level log level as follows.  [ This is a dev.mode only message. ]\n\tlog4j.logger.%s  = DEBUG, console, filelog\n", bundle.getSymbolicName(), bundle.getBundleId(), bundle.getVersion(), bundle.getLocation(), loggerName);
            this.log.warn(msg);
        }
        this.printBundleDebugInfo(bundle);
    }

    public void destroy() throws Exception {
        if (isDevMode) {
            Bundle bundle = this.bundle();
            this.log.warn(String.format("\n\n\tSpring context destroyed : %s id(%d) v(%s) \n", bundle.getSymbolicName(), bundle.getBundleId(), bundle.getVersion()));
        }
    }

    private void printBundleDebugInfo(Bundle bundle) {
        if (this.log.isDebugEnabled()) {
            StringWriter sw = new StringWriter();
            PrintWriter out = new PrintWriter(sw);
            out.println();
            out.format("\tBundle Id : %d\n", bundle.getBundleId());
            out.format("\tBundle Name : %s\n", bundle.getSymbolicName());
            out.format("\tBundle Location : %s\n", bundle.getLocation());
            out.format("\tBundle Version : %s\n", bundle.getVersion());
            out.format("\tBundle Headers :\n", new Object[0]);
            Dictionary headers = bundle.getHeaders();
            Enumeration keys = headers.keys();
            while (keys.hasMoreElements()) {
                Object key = keys.nextElement();
                Object value = headers.get(key);
                out.format("\t\t%s: %s\n", key, value);
            }
            out.println();
            this.log.debug(sw.toString());
        }
    }

    private Bundle bundle() {
        return this.bundleContext.getBundle();
    }

    private String getLoggerName() {
        return String.format("%s.spring", this.bundle().getSymbolicName());
    }
}

