/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.web.servlet.plugin.request;

import com.atlassian.web.servlet.api.ServletForwarder;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Optional;
import java.util.function.Supplier;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpServletResponseWrapper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RedirectInterceptingResponse
extends HttpServletResponseWrapper {
    private static final Logger log = LoggerFactory.getLogger(RedirectInterceptingResponse.class);
    private static final URI ROOT_PATH = URI.create("/");
    private static final URI ROOT_CONTEXT_PATH = URI.create("");
    private static final String SEND_REDIRECT_ONGOING = RedirectInterceptingResponse.class.getName() + ".sendRedirect";
    private final Supplier<Optional<ServletForwarder>> forwarder;
    private final HttpServletRequest request;
    private final HttpServletResponse response;

    public RedirectInterceptingResponse(HttpServletResponse response, Supplier<Optional<ServletForwarder>> forwarder, HttpServletRequest request) {
        super(response);
        this.forwarder = forwarder;
        this.request = request;
        this.response = response;
    }

    public void sendRedirect(String location) throws IOException {
        boolean ongingWrappedSendRedirect = Boolean.TRUE == this.request.getAttribute(SEND_REDIRECT_ONGOING);
        boolean forwardPerformed = ongingWrappedSendRedirect ? false : this.resolveLocation(location).flatMap(uri -> this.forwarder.get().map(fwd -> fwd.forwardSafely(this.request, this.response, uri))).orElse(false);
        if (!forwardPerformed) {
            this.request.setAttribute(SEND_REDIRECT_ONGOING, (Object)Boolean.TRUE);
            super.sendRedirect(location);
            this.request.setAttribute(SEND_REDIRECT_ONGOING, null);
        }
    }

    private Optional<URI> resolveLocation(String location) {
        Optional<URI> locationValidated;
        try {
            URI locationFull = new URI(location);
            URI contextUri = new URI(this.request.getContextPath());
            URI locationRelativeToContext = contextUri.relativize(locationFull);
            if (locationRelativeToContext.equals(locationFull) && !contextUri.equals(ROOT_CONTEXT_PATH)) {
                return Optional.empty();
            }
            locationValidated = Optional.of(ROOT_PATH.resolve(locationRelativeToContext));
        }
        catch (URISyntaxException e) {
            log.warn("Invalid redirect URL: " + location, (Throwable)e);
            locationValidated = Optional.empty();
        }
        return locationValidated;
    }
}

