/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.web.servlet.plugin;

import com.atlassian.plugin.servlet.ServletContextFactory;
import com.atlassian.plugin.spring.scanner.annotation.export.ExportAsService;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.soy.renderer.SoyTemplateRenderer;
import com.atlassian.web.servlet.api.LocationUpdater;
import com.atlassian.web.servlet.plugin.RememberingServletForwarder;
import java.io.Writer;
import java.util.Collections;
import javax.servlet.ServletContext;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@ExportAsService
@Component
public class SoyLocationUpdater
implements LocationUpdater {
    public static final String SOY_RESOURCE = "com.atlassian.web.atlassian-servlet-plugin:location-replacer";
    public static final String SOY_TEMPLATE = "Atlassian.Web.Servlet.locationReplacerScript";
    private final RememberingServletForwarder forwarder;
    private final SoyTemplateRenderer renderer;
    private final ServletContextFactory contextFactory;

    @Autowired
    public SoyLocationUpdater(RememberingServletForwarder forwarder, @ComponentImport SoyTemplateRenderer renderer, @ComponentImport ServletContextFactory contextFactory) {
        this.forwarder = forwarder;
        this.renderer = renderer;
        this.contextFactory = contextFactory;
    }

    public void updateLocation(Writer writer) {
        this.forwarder.consumeLastLocation(lastLocation -> {
            ServletContext context = this.contextFactory.getServletContext();
            String location = context.getContextPath() + lastLocation.toASCIIString();
            this.renderer.render((Appendable)writer, SOY_RESOURCE, SOY_TEMPLATE, Collections.singletonMap("location", location));
        });
    }
}

