/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.prettyurls.internal.rules;

import com.atlassian.plugin.servlet.filter.FilterLocation;
import com.atlassian.prettyurls.api.route.DefaultUrlRouteRuleSetKey;
import com.atlassian.prettyurls.api.route.RoutePredicate;
import com.atlassian.prettyurls.api.route.UrlRouteRule;
import com.atlassian.prettyurls.api.route.UrlRouteRuleSet;
import com.atlassian.prettyurls.internal.util.UrlUtils;
import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import com.sun.jersey.api.uri.UriTemplate;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.dom4j.Element;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UrlRouteRuleSetParser {
    private static final Logger log = LoggerFactory.getLogger(UrlRouteRuleSetParser.class);
    private static final ArrayList<String> HEAD = Lists.newArrayList((Object[])new String[]{"HEAD"});
    private static final ArrayList<String> GET = Lists.newArrayList((Object[])new String[]{"GET"});
    private static final ArrayList<String> POST = Lists.newArrayList((Object[])new String[]{"POST"});
    private static final ArrayList<String> PUT = Lists.newArrayList((Object[])new String[]{"PUT"});
    private static final ArrayList<String> DELETE = Lists.newArrayList((Object[])new String[]{"DELETE"});
    private static final ArrayList<String> OPTIONS = Lists.newArrayList((Object[])new String[]{"OPTIONS"});
    private static final ArrayList<String> PATCH = Lists.newArrayList((Object[])new String[]{"PATCH"});

    public UrlRouteRuleSet parse(String moduleKey, Element element, FilterLocation location, PredicateMaker predicateMaker) {
        Preconditions.checkNotNull((Object)moduleKey);
        Preconditions.checkNotNull((Object)element);
        UrlRouteRuleSet.Builder builder = new UrlRouteRuleSet.Builder().setKey(new DefaultUrlRouteRuleSetKey(moduleKey)).setLocation(location);
        String path = element.attributeValue("path", "").trim();
        if (!path.isEmpty()) {
            if (!this.validatePath(path)) {
                log.error("'" + path + "' is not an acceptable top level path for URL routing.");
                return null;
            }
        } else {
            log.error("You must provide a path attribute in order to get URL routing.");
            return null;
        }
        builder.addTopLevelPath(UrlUtils.startWithSlash(path));
        builder.setPredicate(predicateMaker.makeRuleSetPredicate(element));
        this.parseRules("route", element, builder, predicateMaker, path, Collections.emptyList());
        this.parseRules("head", element, builder, predicateMaker, path, HEAD);
        this.parseRules("get", element, builder, predicateMaker, path, GET);
        this.parseRules("post", element, builder, predicateMaker, path, POST);
        this.parseRules("put", element, builder, predicateMaker, path, PUT);
        this.parseRules("delete", element, builder, predicateMaker, path, DELETE);
        this.parseRules("options", element, builder, predicateMaker, path, OPTIONS);
        this.parseRules("patch", element, builder, predicateMaker, path, PATCH);
        return builder.build();
    }

    private void parseRules(String elementName, Element element, UrlRouteRuleSet.Builder builder, PredicateMaker predicateMaker, String path, List<String> providedHttpVerbs) {
        List elements = element.elements(elementName);
        for (Element e : elements) {
            String fromStr = e.attributeValue("from");
            String toStr = e.attributeValue("to", "").trim();
            RoutePredicate<UrlRouteRule> routePredicate = predicateMaker.makeRulePredicate(e);
            if (toStr.isEmpty()) {
                log.error("Encountered blank to=\"\" rule.  Ignoring it...");
                continue;
            }
            if (fromStr == null) {
                log.error("Missing from=\"\" rule.  Ignoring it...");
                continue;
            }
            UriTemplate from = fromStr.trim().isEmpty() ? this.createURI(path) : this.createURI(path, fromStr);
            UriTemplate to = this.createURI("", toStr);
            List<String> httpVerbs = providedHttpVerbs;
            if (httpVerbs.isEmpty()) {
                httpVerbs = this.parseHttpVerbs(e);
            }
            if (from == null || to == null) continue;
            builder.addRule(from, to, httpVerbs, routePredicate, UrlRouteRule.ParameterMode.PASS_UNMAPPED);
        }
    }

    private List<String> parseHttpVerbs(Element e) {
        String[] split;
        ArrayList httpVerbs = Lists.newArrayList();
        String verbs = e.attributeValue("verbs", "");
        for (String verb : split = verbs.split(",")) {
            if ((verb = verb.trim()).isEmpty()) continue;
            httpVerbs.add(verb.toUpperCase());
        }
        return httpVerbs;
    }

    private boolean validatePath(String path) {
        return !path.equals("/");
    }

    private UriTemplate createURI(String path, String uriStr) {
        String template = UrlUtils.prependPath(path, uriStr);
        try {
            return new UriTemplate(template);
        }
        catch (IllegalArgumentException e) {
            log.error("Unable to parse routing URI " + String.valueOf(template));
            return null;
        }
    }

    private UriTemplate createURI(String uriStr) {
        try {
            return new UriTemplate(uriStr);
        }
        catch (IllegalArgumentException e) {
            log.error("Unable to parse routing URI " + String.valueOf(uriStr));
            return null;
        }
    }

    public static interface PredicateMaker {
        public RoutePredicate<UrlRouteRuleSet> makeRuleSetPredicate(Element var1);

        public RoutePredicate<UrlRouteRule> makeRulePredicate(Element var1);
    }
}

