/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.prettyurls.internal.route;

import com.atlassian.ozymandias.SafePluginPointAccess;
import com.atlassian.plugin.servlet.filter.FilterLocation;
import com.atlassian.prettyurls.api.route.RoutePredicate;
import com.atlassian.prettyurls.api.route.RouteService;
import com.atlassian.prettyurls.api.route.UrlRouteRule;
import com.atlassian.prettyurls.api.route.UrlRouteRuleSet;
import com.atlassian.prettyurls.internal.route.UrlRouter;
import com.atlassian.prettyurls.internal.util.UrlUtils;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.Maps;
import com.sun.jersey.api.uri.UriTemplate;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Callable;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.core.UriBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class UrlRouterImpl
implements UrlRouter {
    private static final Logger log = LoggerFactory.getLogger(UrlRouterImpl.class);
    private final RouteService routeService;

    @Autowired
    public UrlRouterImpl(RouteService routeService) {
        this.routeService = routeService;
    }

    @Override
    public Result route(HttpServletRequest httpRequest, FilterLocation filterLocation) {
        String requestURI;
        try {
            requestURI = this.makeRequestURI(httpRequest);
        }
        catch (URISyntaxException e) {
            log.error("Failed to create requestUri {} due to: {}", (Object)httpRequest.getRequestURI(), (Object)e.getMessage());
            return new Result(null, false);
        }
        Set<UrlRouteRuleSet> urlRouteRuleSets = this.getRouteRuleSets(filterLocation, requestURI);
        for (UrlRouteRuleSet urlRouteRuleSet : urlRouteRuleSets) {
            if (!this.ruleSetEnabled(httpRequest, urlRouteRuleSet)) continue;
            for (UrlRouteRule urlRouteRule : urlRouteRuleSet.getUrlRouteRules()) {
                if (!this.ruleEnabled(httpRequest, urlRouteRule)) continue;
                HashMap<String, String> parsedValues = new HashMap<String, String>();
                if (!urlRouteRule.getFrom().match((CharSequence)requestURI, parsedValues) || !this.httpVerbsMatch(urlRouteRule, httpRequest)) continue;
                String toURI = this.buildToURI(urlRouteRule, parsedValues);
                return new Result(toURI, true);
            }
        }
        return new Result(null, false);
    }

    private boolean httpVerbsMatch(UrlRouteRule urlRouteRule, HttpServletRequest httpRequest) {
        List<String> httpVerbs = urlRouteRule.getHttpVerbs();
        if (httpVerbs.size() == 0) {
            return true;
        }
        String method = httpRequest.getMethod();
        method = method == null ? "" : method.toUpperCase();
        for (String httpVerb : httpVerbs) {
            if (!method.equals(httpVerb)) continue;
            return true;
        }
        return false;
    }

    private String buildToURI(UrlRouteRule urlRouteRule, Map<String, String> parsedFromValues) {
        HashMap unmappedFromValues = Maps.newHashMap(parsedFromValues);
        UrlRouteRule.ParameterMode parameterMode = urlRouteRule.getParameterMode();
        UriTemplate toTemplate = urlRouteRule.getTo();
        List templateVariables = toTemplate.getTemplateVariables();
        HashMap toValues = Maps.newHashMap();
        for (String variable : templateVariables) {
            if (!unmappedFromValues.containsKey(variable)) continue;
            toValues.put(variable, unmappedFromValues.get(variable));
            unmappedFromValues.remove(variable);
        }
        String toURI = toTemplate.createURI((Map)toValues);
        HashMap parametersToPass = Maps.newHashMap();
        if (parameterMode == UrlRouteRule.ParameterMode.PASS_ALL) {
            parametersToPass.putAll(parsedFromValues);
        }
        if (parameterMode == UrlRouteRule.ParameterMode.PASS_UNMAPPED) {
            parametersToPass.putAll(unmappedFromValues);
        }
        UriBuilder uriBuilder = UriBuilder.fromUri((String)UrlUtils.startWithSlash(toURI));
        for (Map.Entry entry : parametersToPass.entrySet()) {
            uriBuilder.queryParam((String)entry.getKey(), new Object[]{entry.getValue()});
        }
        toURI = uriBuilder.build(new Object[0]).toString();
        return toURI;
    }

    private boolean ruleSetEnabled(HttpServletRequest httpRequest, UrlRouteRuleSet urlRouteRuleSet) {
        RoutePredicate<UrlRouteRuleSet> predicate = urlRouteRuleSet.getPredicate();
        return this.runPredicateSafely(httpRequest, urlRouteRuleSet, predicate);
    }

    private boolean ruleEnabled(HttpServletRequest httpRequest, UrlRouteRule urlRouteRule) {
        RoutePredicate<UrlRouteRule> predicate = urlRouteRule.getPredicate();
        return this.runPredicateSafely(httpRequest, urlRouteRule, predicate);
    }

    private <T> boolean runPredicateSafely(final HttpServletRequest httpRequest, final T rule, final RoutePredicate<T> predicate) {
        Boolean result = (Boolean)SafePluginPointAccess.to().callable((Callable)new Callable<Boolean>(){

            @Override
            public Boolean call() throws Exception {
                return predicate.apply(httpRequest, rule);
            }
        });
        return result == null ? false : result;
    }

    @VisibleForTesting
    Set<UrlRouteRuleSet> getRouteRuleSets(FilterLocation filterLocation, String requestURI) {
        return this.routeService.getRouteRuleSets(filterLocation, requestURI);
    }

    @VisibleForTesting
    String makeRequestURI(HttpServletRequest httpServletRequest) throws URISyntaxException {
        String context;
        String requestURI = new URI(httpServletRequest.getRequestURI()).normalize().toString();
        if (requestURI.startsWith(context = httpServletRequest.getContextPath())) {
            requestURI = requestURI.substring(context.length());
        }
        return requestURI;
    }

    static class Result
    implements UrlRouter.Result {
        private final String toURI;
        private final boolean routed;

        private Result(String toURI, boolean routed) {
            this.toURI = toURI;
            this.routed = routed;
        }

        @Override
        public String toURI() {
            return this.toURI;
        }

        @Override
        public boolean isRouted() {
            return this.routed;
        }
    }
}

