/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.prettyurls.api.route;

import com.atlassian.prettyurls.api.route.RoutePredicate;
import com.atlassian.prettyurls.api.route.RoutePredicates;
import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import com.sun.jersey.api.uri.UriTemplate;
import java.util.List;

public class UrlRouteRule {
    private final UriTemplate from;
    private final UriTemplate to;
    private final ParameterMode parameterMode;
    private final List<String> httpVerbs;
    private final RoutePredicate<UrlRouteRule> predicate;

    public UrlRouteRule(UriTemplate from, UriTemplate to, List<String> httpVerbs, ParameterMode parameterMode) {
        this(from, to, httpVerbs, parameterMode, RoutePredicates.alwaysTrue());
    }

    public UrlRouteRule(UriTemplate from, UriTemplate to, List<String> httpVerbs, ParameterMode parameterMode, RoutePredicate<UrlRouteRule> predicate) {
        this.from = (UriTemplate)Preconditions.checkNotNull((Object)from);
        this.to = (UriTemplate)Preconditions.checkNotNull((Object)to);
        this.httpVerbs = (List)Preconditions.checkNotNull(httpVerbs);
        this.parameterMode = (ParameterMode)((Object)Preconditions.checkNotNull((Object)((Object)parameterMode)));
        this.predicate = (RoutePredicate)Preconditions.checkNotNull(predicate);
    }

    public UriTemplate getFrom() {
        return this.from;
    }

    public UriTemplate getTo() {
        return this.to;
    }

    public ParameterMode getParameterMode() {
        return this.parameterMode;
    }

    public List<String> getHttpVerbs() {
        return this.httpVerbs;
    }

    public RoutePredicate<UrlRouteRule> getPredicate() {
        return this.predicate;
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("from", (Object)this.from).add("to", (Object)this.to).add("httpVerbs", this.httpVerbs).add("parameterMode", (Object)this.parameterMode).add("predicate", this.predicate).toString();
    }

    public static enum ParameterMode {
        PASS_ALL,
        PASS_UNMAPPED,
        PASS_NONE;

    }
}

