/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.webresource.plugin.prebake.resources;

import com.atlassian.webresource.plugin.prebake.exception.PreBakeIOException;
import com.atlassian.webresource.plugin.prebake.resources.ResourceCollector;
import com.atlassian.webresource.plugin.prebake.resources.ResourceContent;
import java.io.IOException;
import java.net.URI;
import org.apache.http.HttpEntity;
import org.apache.http.HttpHost;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.util.EntityUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class HttpResourceCollector
implements ResourceCollector {
    private static final Logger LOGGER = LoggerFactory.getLogger(HttpResourceCollector.class);
    private static CloseableHttpClient httpClient = HttpClients.createDefault();

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public ResourceContent collect(URI uri) throws PreBakeIOException {
        try (CloseableHttpResponse response = this.performGet(uri);){
            if (response == null || response.getStatusLine().getStatusCode() != 200 || response.getEntity() == null) {
                String msg = String.format("Wrong HTTP response for %s: %s", uri, String.valueOf(response));
                LOGGER.error(msg);
                throw new PreBakeIOException(msg);
            }
            HttpEntity entity = response.getEntity();
            ResourceContent resourceContent = new ResourceContent(uri, entity.getContentType().getValue(), EntityUtils.toByteArray(entity));
            return resourceContent;
        }
        catch (IOException e) {
            String msg = String.format("Problem fetching resource: %s", uri);
            LOGGER.error(msg, (Throwable)e);
            throw new PreBakeIOException(msg, e);
        }
    }

    private CloseableHttpResponse performGet(URI uri) throws IOException {
        return httpClient.execute(new HttpHost(uri.getHost(), uri.getPort(), uri.getScheme()), new HttpGet(uri));
    }
}

