/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.webresource.plugin.prebake.discovery;

import com.atlassian.plugin.webresource.impl.snapshot.Bundle;
import com.atlassian.plugin.webresource.impl.snapshot.RootPage;
import com.atlassian.plugin.webresource.prebake.PrebakeWebResourceAssembler;
import com.atlassian.plugin.webresource.prebake.PrebakeWebResourceAssemblerFactory;
import com.atlassian.webresource.api.assembler.WebResourceAssembler;
import com.atlassian.webresource.api.prebake.Coordinate;
import com.atlassian.webresource.api.prebake.Dimensions;
import com.atlassian.webresource.plugin.prebake.discovery.WebResourceCrawler;
import com.atlassian.webresource.plugin.prebake.resources.Resource;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.BlockingQueue;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class RootPageCrawler
implements WebResourceCrawler {
    private final Logger log = LoggerFactory.getLogger(RootPageCrawler.class);
    private final PrebakeWebResourceAssemblerFactory assemblerFactory;
    private final Iterable<RootPage> rootPages;
    private final Dimensions valueWhitelist;

    public RootPageCrawler(PrebakeWebResourceAssemblerFactory assemblerFactory, Iterable<RootPage> rootPages, Dimensions valueWhitelist) {
        this.rootPages = rootPages;
        this.assemblerFactory = assemblerFactory;
        this.valueWhitelist = valueWhitelist;
    }

    @Override
    public void crawl(BlockingQueue<Resource> queue) throws InterruptedException {
        this.log.debug("Getting resource URLs from Root Page Crawler");
        for (RootPage rp : this.rootPages) {
            String rpKey = rp.getWebResource().getKey();
            this.log.debug("Generating resource URLs for root page {}", (Object)rpKey);
            Dimensions dims = this.assemblerFactory.computeBundleDimensions((Bundle)rp.getWebResource()).whitelistValues(this.valueWhitelist);
            this.log.debug("{} dimensions are:\n {}", (Object)rpKey, (Object)dims);
            this.log.debug("The size of the cartesian product is: {}", (Object)dims.cartesianProductSize());
            Iterator coords = dims.cartesianProduct().iterator();
            while (coords.hasNext()) {
                WebResourceAssembler assembler = this.createAssembler(rp, (Coordinate)coords.next(), this.assemblerFactory);
                this.crawlAssembledResource(assembler.assembled(), queue);
            }
        }
    }

    @Override
    public List<String> getTargets() {
        return StreamSupport.stream(this.rootPages.spliterator(), false).map(RootPage::getWebResource).map(Bundle::getKey).collect(Collectors.toList());
    }

    private WebResourceAssembler createAssembler(RootPage page, Coordinate coord, PrebakeWebResourceAssemblerFactory fct) {
        PrebakeWebResourceAssembler assembler = fct.create().withCoordinate(coord).build();
        assembler.resources().requirePage(page.getWebResource().getKey());
        return assembler;
    }
}

