/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.webresource.plugin.i18n;

import java.util.Locale;
import org.apache.commons.lang.StringUtils;

public class LocaleUtils {
    public static String serialize(Locale locale) {
        StringBuilder str = new StringBuilder(locale.getLanguage());
        String country = locale.getCountry();
        if (StringUtils.isBlank((String)country)) {
            return str.toString();
        }
        str.append("-").append(country);
        String variant = locale.getVariant();
        if (StringUtils.isBlank((String)variant)) {
            return str.toString();
        }
        str.append("-").append(variant);
        return str.toString();
    }

    public static Locale deserialize(String str) {
        String[] split = str.split("-");
        switch (split.length) {
            case 1: {
                return new Locale(split[0]);
            }
            case 2: {
                return new Locale(split[0], split[1]);
            }
            case 3: {
                return new Locale(split[0], split[1], split[2]);
            }
        }
        throw new IllegalArgumentException("Cannot parse locale: " + str);
    }
}

