/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.oauth.serviceprovider.internal.servlet.user;

import com.atlassian.oauth.serviceprovider.ServiceProviderToken;
import com.atlassian.oauth.serviceprovider.ServiceProviderTokenStore;
import com.atlassian.oauth.serviceprovider.internal.servlet.authorize.LoginRedirector;
import com.atlassian.sal.api.message.LocaleResolver;
import com.atlassian.sal.api.user.UserManager;
import com.atlassian.templaterenderer.TemplateRenderer;
import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Iterables;
import java.io.IOException;
import java.io.Writer;
import java.net.URI;
import java.text.DateFormat;
import java.util.Date;
import java.util.Locale;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.springframework.beans.factory.annotation.Qualifier;

public class AccessTokensServlet
extends HttpServlet {
    public static final String PATH = "/plugins/servlet/oauth/users/access-tokens";
    private static final String TEMPLATE = "templates/user/access-tokens.vm";
    private static final String URL_REGEX_PATTERN = "((.*?)(https?://\\S+))";
    private final ServiceProviderTokenStore store;
    private final UserManager userManager;
    private final LoginRedirector loginRedirector;
    private final TemplateRenderer templateRenderer;
    private final LocaleResolver localeResolver;
    private static final Function<ServiceProviderToken, TokenRepresentation> toTokenRepresentation = new Function<ServiceProviderToken, TokenRepresentation>(){

        public TokenRepresentation apply(ServiceProviderToken from) {
            return new TokenRepresentation(from);
        }
    };

    public AccessTokensServlet(@Qualifier(value="tokenStore") ServiceProviderTokenStore store, UserManager userManager, LocaleResolver localeResolver, LoginRedirector loginRedirector, TemplateRenderer templateRenderer) {
        this.store = (ServiceProviderTokenStore)Preconditions.checkNotNull((Object)store, (Object)"store");
        this.userManager = (UserManager)Preconditions.checkNotNull((Object)userManager, (Object)"userManager");
        this.localeResolver = (LocaleResolver)Preconditions.checkNotNull((Object)localeResolver, (Object)"localeResolver");
        this.loginRedirector = (LoginRedirector)Preconditions.checkNotNull((Object)loginRedirector, (Object)"loginRedirector");
        this.templateRenderer = (TemplateRenderer)Preconditions.checkNotNull((Object)templateRenderer, (Object)"templateRenderer");
    }

    public void doGet(HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        String username = this.userManager.getRemoteUsername(request);
        if (username == null) {
            this.loginRedirector.redirectToLogin(request, response);
            return;
        }
        Locale locale = this.localeResolver.getLocale(request);
        ImmutableMap context = ImmutableMap.of((Object)"tokenItems", (Object)ImmutableList.copyOf(this.getTokenRepresentations(username)), (Object)"dateFormat", (Object)DateFormat.getDateInstance(2, locale), (Object)"timeFormat", (Object)DateFormat.getTimeInstance(3, locale));
        response.setContentType("text/html;charset=UTF-8");
        this.templateRenderer.render(this.getTemplate(), (Map)context, (Writer)response.getWriter());
    }

    private Iterable<TokenRepresentation> getTokenRepresentations(String username) {
        return Iterables.transform((Iterable)this.store.getAccessTokensForUser(username), toTokenRepresentation);
    }

    public void doPost(HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        String username = this.userManager.getRemoteUsername(request);
        if (username == null) {
            response.sendError(401);
            return;
        }
        String tokenParam = request.getParameter("token");
        if (tokenParam == null) {
            response.sendError(400);
            return;
        }
        ServiceProviderToken token = this.store.get(tokenParam);
        if (token == null) {
            return;
        }
        if (!username.equals(token.getUser().getName())) {
            response.sendError(401);
            return;
        }
        this.store.removeAndNotify(tokenParam);
    }

    protected String getTemplate() {
        return TEMPLATE;
    }

    private static URI parseUriFromDescription(String description) {
        Pattern p = Pattern.compile(URL_REGEX_PATTERN);
        Matcher m = p.matcher(description.trim());
        if (!m.matches()) {
            return null;
        }
        try {
            return URI.create(m.group(3));
        }
        catch (IllegalArgumentException e) {
            return null;
        }
    }

    public static final class TokenRepresentation {
        private final ServiceProviderToken token;
        private final URI consumerUri;

        TokenRepresentation(ServiceProviderToken token) {
            this.token = token;
            this.consumerUri = AccessTokensServlet.parseUriFromDescription(this.getDescription());
        }

        public String getToken() {
            return this.token.getToken();
        }

        public String getConsumerName() {
            if (this.token.hasProperty("alternate.consumer.name")) {
                return this.token.getProperty("alternate.consumer.name");
            }
            return this.token.getConsumer().getName();
        }

        public String getConsumerHostName() {
            URI uri = this.getConsumerUri();
            return uri == null ? null : uri.getHost();
        }

        public URI getConsumerUri() {
            return this.consumerUri;
        }

        public String getDescription() {
            return this.token.getConsumer().getDescription();
        }

        public Date getCreationTime() {
            return new Date(this.token.getCreationTime());
        }

        public Date getExpirationTime() {
            return new Date(this.token.getCreationTime() + this.token.getTimeToLive());
        }

        public int getDaysTillExpiration() {
            long millisTillExpiration = this.token.getCreationTime() + this.token.getTimeToLive() - System.currentTimeMillis();
            if (millisTillExpiration < 0L) {
                millisTillExpiration = 0L;
            }
            return (int)(millisTillExpiration / 86400000L);
        }
    }
}

