/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.oauth.serviceprovider.internal.servlet;

import com.atlassian.oauth.serviceprovider.internal.servlet.TransactionException;
import com.atlassian.sal.api.transaction.TransactionCallback;
import com.atlassian.sal.api.transaction.TransactionTemplate;
import com.google.common.base.Preconditions;
import java.io.IOException;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public abstract class TransactionalServlet
extends HttpServlet {
    private final TransactionTemplate transactionTemplate;
    private final ServeInTransaction GET = new ServeInTransaction(){

        @Override
        public void serve(HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
            TransactionalServlet.this.doGetInTransaction(request, response);
        }
    };
    private final ServeInTransaction POST = new ServeInTransaction(){

        @Override
        public void serve(HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
            TransactionalServlet.this.doPostInTransaction(request, response);
        }
    };

    public TransactionalServlet(TransactionTemplate transactionTemplate) {
        this.transactionTemplate = (TransactionTemplate)Preconditions.checkNotNull((Object)transactionTemplate, (Object)"transactionTemplate");
    }

    protected final void doGet(HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        this.serve(this.GET, request, response);
    }

    protected void doGetInTransaction(HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
    }

    protected final void doPost(HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        this.serve(this.POST, request, response);
    }

    protected void doPostInTransaction(HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
    }

    private void serve(final ServeInTransaction inTransaction, final HttpServletRequest request, final HttpServletResponse response) throws IOException, ServletException {
        try {
            this.transactionTemplate.execute((TransactionCallback)new TransactionCallback<Void>(){

                public Void doInTransaction() {
                    try {
                        inTransaction.serve(request, response);
                    }
                    catch (IOException e) {
                        throw new TransactionException(e);
                    }
                    catch (ServletException e) {
                        throw new TransactionException((Exception)((Object)e));
                    }
                    return null;
                }
            });
        }
        catch (TransactionException e) {
            if (e.getCause() instanceof IOException) {
                throw (IOException)e.getCause();
            }
            throw (ServletException)e.getCause();
        }
    }

    private static interface ServeInTransaction {
        public void serve(HttpServletRequest var1, HttpServletResponse var2) throws IOException, ServletException;
    }
}

