define('atlassian-nps-plugin/js/nps/server/nps-status-manager', [
    'atlassian-nps-plugin/js/amd-shims/ajs',
    'jquery',
    'aui/flag'
],
/**
 * Handles the server interactions for getting/setting whether NPS is enabled
 * or disabled on an instance. Only applies to Server instances, not Cloud.
 * @param AJS
 * @param $ jQuery
 * @param flag AUI flag
 */
function(
    AJS,
    $,
    flag
) {
    'use strict';

    function getNpsStatus() {
        return $.ajax({
            url: AJS.contextPath() + "/rest/nps/1.0/status/enable",
            cache: false,
            contentType: "application/json",
            error: function() {
                flag({
                    type: "error",
                    body: AJS.I18n.getText('nps.btf.admin.error.retrieve'),
                    close: "manual"
                }).setAttribute("id", "status-retrieval-failed");
            }
        });
    }

    function updateNpsStatus(newNpsStatus, options) {
        options = options || {};
        return $.ajax({
            url: AJS.contextPath() + '/rest/nps/1.0/status/enable',
            type: 'PUT',
            contentType: 'application/json',
            data: JSON.stringify({npsEnabled: newNpsStatus}),
            error: function() {
                if (options.useErrorFlags) {
                    flag({
                        type: 'error',
                        body: AJS.I18n.getText('nps.btf.admin.error.save'),
                        close: 'manual'
                    }).setAttribute('id', 'status-update-failed');
                } else {
                    AJS.error(AJS.I18n.getText('nps.btf.admin.error.save'));
                }
            }
        });
    }

    return {
        getNpsStatus: getNpsStatus,
        updateNpsStatus: updateNpsStatus
    };
});
