require([
    'jquery',
    'atlassian-nps-plugin/js/amd-shims/ajs',
    'atlassian-nps-plugin/js/amd-shims/wrm'
],
/**
 * Handles the initialising of NPS on an instance (i.e. whether it's enabled or disabled by
 * default). Only applies to Server instances, not Cloud.
 * @param $ jQuery
 * @param AJS
 * @param WRM Web Resource Manager for async requiring of web resources
 */
function(
    $,
    AJS,
    WRM
) {
    'use strict';

    AJS.toInit(function() {
        // Initialise NPS if analytics is enabled (i.e. privacy policy has already been accepted)
        var analyticsEnabled = WRM.data.claim("com.atlassian.plugins.atlassian-nps-plugin:nps-acknowledgement-resources.analytics-enabled-data-provider");
        if (analyticsEnabled === "true") {
            initialiseNps();
        } else {
            // When the analytics privacy policy has been accepted we do not want to wait for the next page load to recheck
            // analytics-enabled-data-provider so we listen for the policy-acknowledged event and immediately initialise
            // the NPS status and show the acknowledgement flag
            AJS.bind("analytics-policy-acknowledged", function() {
                initialiseNps();
            });
        }
    });

    function initialiseNps() {
        WRM.require('wr!com.atlassian.plugins.atlassian-nps-plugin:nps-acknowledgement-flag-resources-async', function () {
            require([
                'atlassian-nps-plugin/js/nps/server/acknowledgement-flag',
                'atlassian-nps-plugin/js/nps/product'
            ], function (
                AcknowledgementFlag,
                Product
            ) {
                var active = true;

                if (!Product.allowDisplayAcknowledgementFlag()) {
                    return;
                }

                // Needed for webdriver tests to force acknowledge flag display
                var isTesting = localStorage.getItem('nps-testing') === 'true';

                // Product can enable A/B testing by defining `enableABTesting` method.
                if (typeof Product.enableABTesting === 'function' && Product.enableABTesting()) {
                    /*
                     Using multivariate testing on the NPS initialisation state, with instances being classified according to the
                     the last digit of their SEN number which is in the format "SEN-1234567"
                     - 80% of instances will be prompted to enable NPS using notification flag - SEN ends in 0-7
                     - 20% of instances will have NPS disabled completely - no checkbox/surveys - SEN > 7
                     */
                    var senWithNpsActive = [0, 1, 2, 3, 4, 5, 6, 7];

                    // Check SEN data provider
                    var SEN = WRM.data.claim('com.atlassian.plugins.atlassian-nps-plugin:nps-acknowledgement-resources.sen-data-provider');
                    var lastDigit = parseInt(SEN.slice(-1));

                    active = senWithNpsActive.indexOf(lastDigit) >= 0;
                }

                if (active || isTesting) {
                    AcknowledgementFlag.displayNpsAcknowledgementFlag();
                }
            });
        });
    }
});