/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.gadgets.renderer.internal.http;

import com.atlassian.gadgets.opensocial.spi.Whitelist;
import com.atlassian.http.url.SameOrigin;
import com.atlassian.sal.api.ApplicationProperties;
import com.atlassian.sal.api.UrlMode;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;

public class MessageBundleWhiteList
implements Whitelist {
    private static final String MESSAGE_BUNDLE_URI = "/rest/gadgets/1.0/g/messagebundle";
    private final ApplicationProperties applicationProperties;

    public MessageBundleWhiteList(ApplicationProperties applicationProperties) {
        this.applicationProperties = applicationProperties;
    }

    public boolean allows(URI uri) {
        if (uri == null) {
            return false;
        }
        String normizedUriString = uri.normalize().toASCIIString().toLowerCase();
        try {
            URI applicationUri = new URI(this.applicationProperties.getBaseUrl(UrlMode.ABSOLUTE));
            return SameOrigin.isSameOrigin((URI)uri, (URI)applicationUri) && normizedUriString.startsWith(applicationUri.toString() + MESSAGE_BUNDLE_URI);
        }
        catch (MalformedURLException | URISyntaxException e) {
            throw new RuntimeException(e);
        }
    }
}

