/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.gadgets.renderer.internal.http;

import com.atlassian.applinks.api.ApplicationLink;
import com.atlassian.applinks.api.ApplicationLinkService;
import com.atlassian.gadgets.opensocial.spi.Whitelist;
import com.atlassian.http.url.SameOrigin;
import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.collect.Iterables;
import java.net.MalformedURLException;
import java.net.URI;
import java.util.function.Predicate;
import java.util.stream.StreamSupport;

public class AppLinksWhitelist
implements Whitelist {
    private final ApplicationLinkService appLinkService;

    public AppLinksWhitelist(ApplicationLinkService appLinkService) {
        this.appLinkService = (ApplicationLinkService)Preconditions.checkNotNull((Object)appLinkService, (Object)"appLinkService");
    }

    public boolean allows(URI uri) {
        return StreamSupport.stream(this.appLinks().spliterator(), false).anyMatch(AppLinksWhitelist.isSameOrigin(uri));
    }

    private Iterable<URI> appLinks() {
        return Iterables.transform((Iterable)this.appLinkService.getApplicationLinks(), this.rpcUri());
    }

    private Function<ApplicationLink, URI> rpcUri() {
        return ExtractRpcUri.INSTANCE;
    }

    private static Predicate<URI> isSameOrigin(URI uri) {
        return p -> {
            try {
                return SameOrigin.isSameOrigin((URI)uri, (URI)p) && uri.getPath().startsWith(p.getPath());
            }
            catch (MalformedURLException e) {
                return false;
            }
        };
    }

    private static enum ExtractRpcUri implements Function<ApplicationLink, URI>
    {
        INSTANCE;


        public URI apply(ApplicationLink appLink) {
            return appLink.getRpcUrl();
        }
    }
}

