/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.gadgets.opensocial.internal;

import com.atlassian.gadgets.opensocial.OpenSocialRequestContext;
import com.atlassian.gadgets.opensocial.internal.ShindigOpenSocialTypeAdapter;
import com.atlassian.gadgets.opensocial.model.AppId;
import com.atlassian.gadgets.opensocial.model.Person;
import com.atlassian.gadgets.opensocial.model.PersonId;
import com.atlassian.gadgets.opensocial.spi.ActivityServiceException;
import com.atlassian.gadgets.opensocial.spi.PersonService;
import com.atlassian.gadgets.util.Uri;
import com.atlassian.sal.api.ApplicationProperties;
import com.atlassian.sal.api.transaction.TransactionCallback;
import com.atlassian.sal.api.transaction.TransactionTemplate;
import com.google.common.collect.Lists;
import java.util.List;
import java.util.Set;
import java.util.concurrent.Future;
import org.apache.shindig.auth.SecurityToken;
import org.apache.shindig.common.util.ImmediateFuture;
import org.apache.shindig.social.ResponseError;
import org.apache.shindig.social.opensocial.model.Activity;
import org.apache.shindig.social.opensocial.spi.ActivityService;
import org.apache.shindig.social.opensocial.spi.GroupId;
import org.apache.shindig.social.opensocial.spi.RestfulCollection;
import org.apache.shindig.social.opensocial.spi.SocialSpiException;
import org.apache.shindig.social.opensocial.spi.UserId;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class ShindigActivityServiceImpl
implements ActivityService {
    private final PersonService personService;
    private final com.atlassian.gadgets.opensocial.spi.ActivityService activityService;
    private final TransactionTemplate txTemplate;
    private final ApplicationProperties applicationProperties;

    @Autowired
    public ShindigActivityServiceImpl(PersonService personService, com.atlassian.gadgets.opensocial.spi.ActivityService activityService, TransactionTemplate txTemplate, ApplicationProperties applicationProperties) {
        this.personService = personService;
        this.activityService = activityService;
        this.txTemplate = txTemplate;
        this.applicationProperties = applicationProperties;
    }

    public Future<RestfulCollection<Activity>> getActivities(final Set<UserId> userIds, final GroupId groupId, String appId, Set<String> fields, final SecurityToken token) throws SocialSpiException {
        try {
            final AppId relativeAppId = AppId.valueOf((String)Uri.relativizeUriAgainstBase((String)this.applicationProperties.getBaseUrl(), (String)appId).toString());
            List activities = (List)this.txTemplate.execute(new TransactionCallback(){

                public Object doInTransaction() {
                    Set<PersonId> people = ShindigOpenSocialTypeAdapter.getPeopleIdsFromUserIds(ShindigActivityServiceImpl.this.personService, userIds, groupId, token);
                    return ShindigActivityServiceImpl.this.activityService.getActivities(people, relativeAppId, ShindigOpenSocialTypeAdapter.convertShindigSecurityTokenToRequestContext(token));
                }
            });
            List shindigActivities = Lists.transform((List)activities, ShindigOpenSocialTypeAdapter.activityToShindigActivityFunction(fields));
            return ImmediateFuture.newInstance((Object)new RestfulCollection(shindigActivities));
        }
        catch (ActivityServiceException e) {
            throw new SocialSpiException(ResponseError.INTERNAL_ERROR, e.getMessage(), (Throwable)e);
        }
    }

    public Future<RestfulCollection<Activity>> getActivities(final UserId userId, GroupId groupId, String appId, Set<String> fields, final Set<String> activityIds, final SecurityToken token) throws SocialSpiException {
        try {
            final OpenSocialRequestContext openSocialRequestContext = ShindigOpenSocialTypeAdapter.convertShindigSecurityTokenToRequestContext(token);
            final AppId relativeAppId = AppId.valueOf((String)Uri.relativizeUriAgainstBase((String)this.applicationProperties.getBaseUrl(), (String)appId).toString());
            List activities = (List)this.txTemplate.execute(new TransactionCallback(){

                public Object doInTransaction() {
                    Person person = ShindigActivityServiceImpl.this.personService.getPerson(userId.getUserId(token), openSocialRequestContext);
                    return ShindigActivityServiceImpl.this.activityService.getActivities(person.getPersonId(), relativeAppId, activityIds, openSocialRequestContext);
                }
            });
            List shindigActivities = Lists.transform((List)activities, ShindigOpenSocialTypeAdapter.activityToShindigActivityFunction(fields));
            return ImmediateFuture.newInstance((Object)new RestfulCollection(shindigActivities));
        }
        catch (ActivityServiceException e) {
            throw new SocialSpiException(ResponseError.INTERNAL_ERROR, e.getMessage(), (Throwable)e);
        }
    }

    public Future<Activity> getActivity(final UserId userId, GroupId groupId, String appId, Set<String> fields, final String activityId, final SecurityToken token) throws SocialSpiException {
        try {
            final AppId relativeAppId = AppId.valueOf((String)Uri.relativizeUriAgainstBase((String)this.applicationProperties.getBaseUrl(), (String)appId).toString());
            com.atlassian.gadgets.opensocial.model.Activity activity = (com.atlassian.gadgets.opensocial.model.Activity)this.txTemplate.execute(new TransactionCallback(){

                public Object doInTransaction() {
                    OpenSocialRequestContext openSocialRequestContext = ShindigOpenSocialTypeAdapter.convertShindigSecurityTokenToRequestContext(token);
                    Person person = ShindigActivityServiceImpl.this.personService.getPerson(userId.getUserId(token), openSocialRequestContext);
                    return ShindigActivityServiceImpl.this.activityService.getActivity(person.getPersonId(), relativeAppId, activityId, openSocialRequestContext);
                }
            });
            return ImmediateFuture.newInstance((Object)ShindigOpenSocialTypeAdapter.convertActivityToShindigActivity(activity, fields));
        }
        catch (ActivityServiceException e) {
            throw new SocialSpiException(ResponseError.INTERNAL_ERROR, e.getMessage(), (Throwable)e);
        }
    }

    public Future<Void> deleteActivities(final UserId userId, GroupId groupId, String appId, final Set<String> activityIds, final SecurityToken token) throws SocialSpiException {
        try {
            final OpenSocialRequestContext openSocialRequestContext = ShindigOpenSocialTypeAdapter.convertShindigSecurityTokenToRequestContext(token);
            final AppId relativeAppId = AppId.valueOf((String)Uri.relativizeUriAgainstBase((String)this.applicationProperties.getBaseUrl(), (String)appId).toString());
            this.txTemplate.execute(new TransactionCallback(){

                public Object doInTransaction() {
                    Person person = ShindigActivityServiceImpl.this.personService.getPerson(userId.getUserId(token), openSocialRequestContext);
                    ShindigActivityServiceImpl.this.activityService.deleteActivities(person.getPersonId(), relativeAppId, activityIds, openSocialRequestContext);
                    return null;
                }
            });
            return ImmediateFuture.newInstance(null);
        }
        catch (ActivityServiceException e) {
            throw new SocialSpiException(ResponseError.INTERNAL_ERROR, e.getMessage(), (Throwable)e);
        }
    }

    public Future<Void> createActivity(final UserId userId, GroupId groupId, String appId, Set<String> fields, final Activity activity, final SecurityToken token) throws SocialSpiException {
        try {
            final OpenSocialRequestContext openSocialRequestContext = ShindigOpenSocialTypeAdapter.convertShindigSecurityTokenToRequestContext(token);
            final AppId relativeAppId = AppId.valueOf((String)Uri.relativizeUriAgainstBase((String)this.applicationProperties.getBaseUrl(), (String)appId).toString());
            this.txTemplate.execute(new TransactionCallback(){

                public Object doInTransaction() {
                    Person person = ShindigActivityServiceImpl.this.personService.getPerson(userId.getUserId(token), openSocialRequestContext);
                    ShindigActivityServiceImpl.this.activityService.createActivity(person.getPersonId(), relativeAppId, ShindigOpenSocialTypeAdapter.convertShindigActivityToActivity(activity), openSocialRequestContext);
                    return null;
                }
            });
            return ImmediateFuture.newInstance(null);
        }
        catch (ActivityServiceException e) {
            throw new SocialSpiException(ResponseError.INTERNAL_ERROR, e.getMessage(), (Throwable)e);
        }
    }
}

