AJS.test.require([
    "jira.webresources:legacy-namespacing",
    "com.atlassian.gadgets.dashboard.refimpl.ui:required-libraries",
    "com.atlassian.gadgets.dashboard:dashboard-test"
], function(){
    module("Directory view test", {
        setup: function() {
            this.view = new JIRA.Dashboard.Views.Directory({
                el: AJS.$("#qunit-fixture")
            });
        },

        teardown: function() {

        }
    });

    test("Should attach self to the specified root element when render is invoked", function(){
        this.view.render();

        equal(AJS.$("#qunit-fixture").find("#directory-page").length, 1);
    });

    test("Should detach self from the DOM when detach is invoked", function(){
        this.view.render();
        this.view.detach();

        equal(AJS.$("#qunit-fixture").find("#directory-page").length, 0);
    });

    test("Should throw searchTextUpdate event when search text box is updated with an empty string", function(){
        var spy = sinon.spy();
        this.view.on("searchTextUpdate", spy);
        this.view.render();

        var $searchBox = AJS.$("#search");
        $searchBox.val("");
        $searchBox.trigger("keyup");

        ok(spy.calledOnce);
        ok(spy.calledWith(""));
    });

    test("Should throw searchTextUpdate event when search text box is triggered with a keyup event", function(){
        var spy = sinon.spy();
        this.view.on("searchTextUpdate", spy);
        this.view.render();

        var $searchBox = AJS.$("#search");
        $searchBox.val("donut");
        $searchBox.trigger(AJS.$.Event("keyup"));

        ok(spy.calledOnce);
        ok(spy.calledWith("donut"));
    });

    test("Should clean up search box when resetUserInput is invoked", function(){
        this.view.render();
        var $searchBox = AJS.$("#search");
        $searchBox.val("donut");

        this.view.resetUserInput();

        equal($searchBox.val(), "");
    });
});