AJS.test.require([
    "jira.webresources:legacy-namespacing",
    "com.atlassian.gadgets.dashboard.refimpl.ui:required-libraries",
    "com.atlassian.gadgets.dashboard:dashboard-test"
], function(){
    module("Directory nav view test", {
        setup: function() {
            this.$rootDiv = AJS.$("#qunit-fixture");

            this.modelCategoryCountStub = sinon.stub(JIRA.Dashboard.Entities.DirectoryViewModel.prototype, "getFilteredCategoryCount");
            this.modelCategoryCountStub.returns([{label: "All", count: 5},{label: "JIRA", count: 4},{label: "Other", count: 1}]);

            this.modelSelectedCategoryStub = sinon.stub(JIRA.Dashboard.Entities.DirectoryViewModel.prototype, "getSelectedCategory");
            this.modelSelectedCategoryStub.returns("JIRA");

            this.view = new JIRA.Dashboard.Views.DirectoryNav({
                model: new JIRA.Dashboard.Entities.DirectoryViewModel({}, {
                    directoryItems: _.extend({}, Backbone.Events)
                }),
                el: this.$rootDiv
            });
        },

        teardown: function() {
            this.modelCategoryCountStub.restore();
            this.modelSelectedCategoryStub.restore();
        }
    });

    test("Should display all categories along with their count", function(){
        this.view.render();

        var items = this.$rootDiv.find("li");
        equal(items.length, 3);

        equal(AJS.$(items[0]).find("a").attr("data-category-label"), "All");
        equal(AJS.$(items[1]).find("a").attr("data-category-label"), "JIRA");
        equal(AJS.$(items[2]).find("a").attr("data-category-label"), "Other");

        equal(AJS.$(items[0]).find("span").text(), "5");
        equal(AJS.$(items[1]).find("span").text(), "4");
        equal(AJS.$(items[2]).find("span").text(), "1");
    });

    test("Should highlight selected category", function(){
        this.view.render();

        equal(this.$rootDiv.find("li.aui-nav-selected").find("a").attr("data-category-label"), "JIRA");
    });

    test("Should throw categorySelect event when an anchor is clicked", function(){
        this.view.render();

        var spy = sinon.spy();
        this.view.on("categorySelect", spy);

        var clickEvent = AJS.$.Event("click");
        this.$rootDiv.find("a[data-category-label='Other']").trigger(clickEvent);

        ok(spy.calledOnce);
        ok(spy.calledWith("Other"));
    });

    test("Should throw categorySelect event when the span associated with the anchor is clicked", function(){
        this.view.render();

        var spy = sinon.spy();
        this.view.on("categorySelect", spy);

        var clickEvent = AJS.$.Event("click");
        this.$rootDiv.find("a[data-category-label='Other'] > span").trigger(clickEvent);

        ok(spy.calledOnce);
        ok(spy.calledWith("Other"));
    });
});