AJS.test.require(["jira.webresources:legacy-namespacing","com.atlassian.gadgets.dashboard.refimpl.ui:required-libraries","com.atlassian.gadgets.dashboard:dashboard-test"],function(){module("Directory message view test",{setup:function(){this.view=new JIRA.Dashboard.Views.DirectoryMessageView({el:AJS.$("#qunit-fixture")})},teardown:function(){}});function inProgressMessageIsRendered(){return AJS.$("#qunit-fixture").find("#in-progress-message").length==1}function failureMessageIsRendered(){return AJS.$("#qunit-fixture").find("#failure-message").length==1}function moreDataMessageIsRendered(){return AJS.$("#qunit-fixture").find("#more-data-message").length==1}test("Should display informational message that not all gadgets have loaded when retrieval is still in progress ",function(){this.view.render({retrievalInProgress:true,retrievalFailed:true,hasUnrenderedData:false,directoryIsVisible:true});ok(inProgressMessageIsRendered());ok(!failureMessageIsRendered());ok(!moreDataMessageIsRendered())});test("Should not display informational message that not all gadgets have loaded when retrieval is no longer in progress ",function(){this.view.render({retrievalInProgress:false,retrievalFailed:false,hasUnrenderedData:false,directoryIsVisible:true});ok(!inProgressMessageIsRendered());ok(!failureMessageIsRendered());ok(!moreDataMessageIsRendered())});test("Should display error message when retrieval has completed and there is at least one failure",function(){this.view.render({retrievalInProgress:false,retrievalFailed:true,hasUnrenderedData:false,directoryIsVisible:true});ok(!inProgressMessageIsRendered());ok(failureMessageIsRendered());ok(!moreDataMessageIsRendered())});test("Should not display error message when retrieval is still in progress regardless of existence of failure",function(){this.view.render({retrievalInProgress:true,retrievalFailed:true,hasUnrenderedData:false,directoryIsVisible:true});ok(inProgressMessageIsRendered());ok(!failureMessageIsRendered());ok(!moreDataMessageIsRendered())});test("Should display informational message that more gadgets are available when new data has arrived and directory is visible",function(){this.view.render({retrievalInProgress:false,retrievalFailed:false,hasUnrenderedData:true,directoryIsVisible:true});ok(!inProgressMessageIsRendered());ok(!failureMessageIsRendered());ok(moreDataMessageIsRendered())});test("Should not display informational message that more gadgets are available when new data has arrived and directory is not visible",function(){this.view.render({retrievalInProgress:false,retrievalFailed:false,hasUnrenderedData:true,directoryIsVisible:false});ok(!inProgressMessageIsRendered());ok(!failureMessageIsRendered());ok(!moreDataMessageIsRendered())});test("Should not display informational message that more gadgets are available when no new data has arrived and directory is visible",function(){this.view.render({retrievalInProgress:false,retrievalFailed:false,hasUnrenderedData:false,directoryIsVisible:true});ok(!inProgressMessageIsRendered());ok(!failureMessageIsRendered());ok(!moreDataMessageIsRendered())});test("Should trigger retrieveRetryRequest event when the user clicks on the link to try retrieving failed items",function(){var spy=sinon.spy();this.view.on("retrieveRetryRequest",spy);this.view.render({retrievalInProgress:false,retrievalFailed:true,hasUnrenderedData:false,directoryIsVisible:true});ok(failureMessageIsRendered());AJS.$("#qunit-fixture").find("a[data-purpose='retry']").trigger(AJS.$.Event("click"));ok(spy.calledOnce)});test("Should trigger additionalItemsLoadRequest event when the user clicks on the link to load more gadgets",function(){var spy=sinon.spy();this.view.on("additionalItemsLoadRequest",spy);this.view.render({retrievalInProgress:false,retrievalFailed:false,hasUnrenderedData:true,directoryIsVisible:true});ok(moreDataMessageIsRendered());AJS.$("#qunit-fixture").find("a[data-purpose='load']").trigger(AJS.$.Event("click"));ok(spy.calledOnce)})});