AJS.test.require(["jira.webresources:legacy-namespacing","com.atlassian.gadgets.dashboard.refimpl.ui:required-libraries","com.atlassian.gadgets.dashboard:dashboard-test"],function(){module("Directory view state test",{setup:function(){this.itemsGetCategorisedItemsStub=sinon.stub(JIRA.Dashboard.Entities.DirectoryItems.prototype,"getCategorisedItems");this.mockCategorisedItems={"JIRA":[new JIRA.Dashboard.Entities.DirectoryItem({"id":"rest/gadgets/1.0/g/com.atlassian.jira.gadgets:introduction-gadget/gadgets/introduction-gadget.xml","titleLabel":"Introduction","titleUri":"","authorLabel":"Atlassian","description":"An introduction to this installation of JIRA.","specUri":"rest/gadgets/1.0/g/com.atlassian.jira.gadgets:introduction-gadget/gadgets/introduction-gadget.xml","categories":["JIRA"],"thumbnailUri":"http://esukmajaya:2990/jira/s/en_USyq5hb4/6327/3/6.3-OD-07-001/_/download/resources/com.atlassian.jira.gadgets:introduction-gadget/text-thumb.png"}),new JIRA.Dashboard.Entities.DirectoryItem({"id":"rest/gadgets/1.0/g/com.atlassian.jira.gadgets:time-since-chart-gadget/gadgets/timesince-gadget.xml","titleLabel":"Time Since Chart","titleUri":"","authorLabel":"Atlassian","description":"Displays the time since a chosen field for each issue for a project or saved filter.","specUri":"rest/gadgets/1.0/g/com.atlassian.jira.gadgets:time-since-chart-gadget/gadgets/timesince-gadget.xml","categories":["Charts","JIRA"],"thumbnailUri":"http://esukmajaya:2990/jira/s/en_USyq5hb4/6327/3/6.3-OD-07-001/_/download/resources/com.atlassian.jira.gadgets:time-since-chart-gadget/timeSince-thumb.png"})],"Charts":[new JIRA.Dashboard.Entities.DirectoryItem({"id":"rest/gadgets/1.0/g/com.atlassian.jira.gadgets:time-since-chart-gadget/gadgets/timesince-gadget.xml","titleLabel":"Time Since Chart","titleUri":"","authorLabel":"Atlassian","description":"Displays the time since a chosen field for each issue for a project or saved filter.","specUri":"rest/gadgets/1.0/g/com.atlassian.jira.gadgets:time-since-chart-gadget/gadgets/timesince-gadget.xml","categories":["Charts","JIRA"],"thumbnailUri":"http://esukmajaya:2990/jira/s/en_USyq5hb4/6327/3/6.3-OD-07-001/_/download/resources/com.atlassian.jira.gadgets:time-since-chart-gadget/timeSince-thumb.png"})],"Other":[new JIRA.Dashboard.Entities.DirectoryItem({"id":"rest/gadgets/1.0/g/com.atlassian.jirafisheyeplugin:fisheye-recent-commits-gadget/gadgets/fisheye-recent-commits-gadget.xml","titleLabel":"__MSG_gadget.fisheye.recentcommits.title__","titleUri":"","authorLabel":"Atlassian","description":"__MSG_gadget.fisheye.recentcommits.description__","specUri":"rest/gadgets/1.0/g/com.atlassian.jirafisheyeplugin:fisheye-recent-commits-gadget/gadgets/fisheye-recent-commits-gadget.xml","categories":["Other"],"thumbnailUri":"http://esukmajaya:2990/jira/s/en_USyq5hb4/6327/3/6.3.2/_/download/resources/com.atlassian.jirafisheyeplugin:fisheye-recent-commits-gadget/fisheyeRecentCommits-thumb.png"})],"All":[new JIRA.Dashboard.Entities.DirectoryItem({"id":"rest/gadgets/1.0/g/com.atlassian.jira.gadgets:introduction-gadget/gadgets/introduction-gadget.xml","titleLabel":"Introduction","titleUri":"","authorLabel":"Atlassian","description":"An introduction to this installation of JIRA.","specUri":"rest/gadgets/1.0/g/com.atlassian.jira.gadgets:introduction-gadget/gadgets/introduction-gadget.xml","categories":["JIRA"],"thumbnailUri":"http://esukmajaya:2990/jira/s/en_USyq5hb4/6327/3/6.3-OD-07-001/_/download/resources/com.atlassian.jira.gadgets:introduction-gadget/text-thumb.png"}),new JIRA.Dashboard.Entities.DirectoryItem({"id":"rest/gadgets/1.0/g/com.atlassian.jira.gadgets:time-since-chart-gadget/gadgets/timesince-gadget.xml","titleLabel":"Time Since Chart","titleUri":"","authorLabel":"Atlassian","description":"Displays the time since a chosen field for each issue for a project or saved filter.","specUri":"rest/gadgets/1.0/g/com.atlassian.jira.gadgets:time-since-chart-gadget/gadgets/timesince-gadget.xml","categories":["Charts","JIRA"],"thumbnailUri":"http://esukmajaya:2990/jira/s/en_USyq5hb4/6327/3/6.3-OD-07-001/_/download/resources/com.atlassian.jira.gadgets:time-since-chart-gadget/timeSince-thumb.png"}),new JIRA.Dashboard.Entities.DirectoryItem({"id":"rest/gadgets/1.0/g/com.atlassian.jirafisheyeplugin:fisheye-recent-commits-gadget/gadgets/fisheye-recent-commits-gadget.xml","titleLabel":"__MSG_gadget.fisheye.recentcommits.title__","titleUri":"","authorLabel":"Atlassian","description":"__MSG_gadget.fisheye.recentcommits.description__","specUri":"rest/gadgets/1.0/g/com.atlassian.jirafisheyeplugin:fisheye-recent-commits-gadget/gadgets/fisheye-recent-commits-gadget.xml","categories":["Other"],"thumbnailUri":"http://esukmajaya:2990/jira/s/en_USyq5hb4/6327/3/6.3.2/_/download/resources/com.atlassian.jirafisheyeplugin:fisheye-recent-commits-gadget/fisheyeRecentCommits-thumb.png"})]};this.itemsGetCategorisedItemsStub.returns(this.mockCategorisedItems);this.itemsRetrievalCompletedStub=sinon.stub(JIRA.Dashboard.Entities.DirectoryItems.prototype,"retrievalCompleted");this.itemsRetrievalFailedStub=sinon.stub(JIRA.Dashboard.Entities.DirectoryItems.prototype,"hasSomeFailure");this.constantsStub=sinon.stub(JIRA.Dashboard.Directory.Constants,"getDefaultCategoryName").returns("All");this.items=new JIRA.Dashboard.Entities.DirectoryItems([],{retriever:new JIRA.Dashboard.Services.ItemRetriever()});this.model=new JIRA.Dashboard.Entities.DirectoryViewModel({},{directoryItems:this.items})},teardown:function(){this.itemsGetCategorisedItemsStub.restore();this.itemsRetrievalCompletedStub.restore();this.itemsRetrievalFailedStub.restore();this.constantsStub.restore()}});test("Should set in progress to true when directory items throws batch retrieving event",function(){this.items.trigger("batchRetrieving");ok(this.model.get("retrievalInProgress"))});test("Should set in progress to false and failure to true when directory items throws a retrieve event and retrieval is done with at least one error",function(){this.items.trigger("batchRetrieving");this.itemsRetrievalCompletedStub.returns(true);this.itemsRetrievalFailedStub.returns(true);this.items.trigger("retrieve",[3,7,5]);ok(!this.model.get("retrievalInProgress"));ok(this.model.get("retrievalFailed"))});test("Should set in progress to false and failure to false when directory items throws a retrieve event and retrieval is done with no error",function(){this.items.trigger("batchRetrieving");this.itemsRetrievalCompletedStub.returns(true);this.itemsRetrievalFailedStub.returns(false);this.items.trigger("retrieve",[3,7,5]);ok(!this.model.get("retrievalInProgress"));ok(!this.model.get("retrievalFailed"))});test("Should do nothing when directory items throws a retrieve event and retrieval is not done",function(){this.items.trigger("batchRetrieving");this.itemsRetrievalCompletedStub.returns(false);this.items.trigger("retrieve",[3,7,5]);ok(this.model.get("retrievalInProgress"));ok(!this.model.get("retrievalFailed"))});test("Should set in progress to false and failure to true when directory items throws a retrieve failure event and retrieval is done",function(){this.items.trigger("batchRetrieving");this.itemsRetrievalCompletedStub.returns(true);this.itemsRetrievalFailedStub.returns(true);this.items.trigger("retrieveFailure");ok(!this.model.get("retrievalInProgress"));ok(this.model.get("retrievalFailed"))});test("Should do nothing when directory items throws a retrieve failure event and retrieval is not done",function(){this.items.trigger("batchRetrieving");this.itemsRetrievalCompletedStub.returns(false);this.items.trigger("retrieveFailure");ok(this.model.get("retrievalInProgress"));ok(!this.model.get("retrievalFailed"))});test("Should set has unrendered data to true when directory items throws a retrieve event and directory is visible",function(){this.model.set("directoryIsVisible",true);var data=[1,3,5];this.items.trigger("retrieve",data);ok(this.model.get("hasUnrenderedData"))});test("Should do nothing when directory items throws a retrieve event and directory is not visible",function(){this.model.set("directoryIsVisible",false);var data=[1,3,5];this.items.trigger("retrieve",data);ok(!this.model.get("hasUnrenderedData"))});test("Should throw messageUpdate events when batch retrieval started",function(){var spy=sinon.spy();this.model.on("messageUpdate",spy);this.items.trigger("batchRetrieving");ok(spy.calledOnce)});test("Should throw messageUpdate event when batch retrieval completed with error",function(){var spy=sinon.spy();this.model.on("messageUpdate",spy);this.itemsRetrievalCompletedStub.returns(true);this.itemsRetrievalFailedStub.returns(false);this.items.trigger("retrieveFailure");ok(spy.calledOnce)});test("Should throw messageUpdate event when batch retrieval completed without error",function(){var spy=sinon.spy();this.model.on("messageUpdate",spy);this.itemsRetrievalCompletedStub.returns(true);this.itemsRetrievalFailedStub.returns(true);this.items.trigger("retrieve",[1,4,6]);ok(spy.calledOnce)});test("Should throw messageUpdate event when new batch of items have been retrieved and the directory is visible",function(){var spy=sinon.spy();this.model.on("messageUpdate",spy);this.model.setDirectoryVisible();this.items.trigger("retrieve",[1,4,7]);ok(spy.calledOnce)});test("Should throw dataUpdate event when new batch of items have been retrieved and the directory is not visible",function(){var spy=sinon.spy();this.model.on("dataUpdate",spy);this.model.setDirectoryNotVisible();this.items.trigger("retrieve",[1,4,7]);ok(spy.calledOnce)});test("Should update search text when set search text is invoked",function(){equal(this.model.getSearchText(),"");this.model.setSearchText("");equal(this.model.getSearchText(),"");this.model.setSearchText("duck");equal(this.model.getSearchText(),"duck");this.model.setSearchText("DuCk");equal(this.model.getSearchText(),"duck")});test("Should update selected category when set selected category is invoked",function(){equal(this.model.getSelectedCategory(),"All");this.model.setSelectedCategory("JIRA");equal(this.model.getSelectedCategory(),"JIRA");this.model.setSelectedCategory("Charts");equal(this.model.getSelectedCategory(),"Charts")});test("Should update categorised items when data is retrieved and they are being rendered immediately",function(){this.model.directoryItems.trigger("retrieve",[1,2,3]);var categorisedItems=this.model.getCategorisedItems();equal(categorisedItems["All"].length,3);equal(categorisedItems["JIRA"].length,2);equal(categorisedItems["Charts"].length,1);equal(categorisedItems["Other"].length,1)});test("Should not update categorised items when more data is retrieved but not being rendered",function(){this.model.setDirectoryVisible();this.model.directoryItems.trigger("retrieve",[1,2,3]);var categorisedItems=this.model.getCategorisedItems();deepEqual(categorisedItems,{})});test("Should filter categorised items when filter is invoked with a search term",function(){var modelGetCategorisedItemsStub=sinon.stub(this.model,"getCategorisedItems");modelGetCategorisedItemsStub.returns(this.mockCategorisedItems);var filtered=this.model.filterCategorisedItems("hipchat");equal(filtered["All"].length,0);equal(filtered["JIRA"].length,0);equal(filtered["Charts"].length,0);equal(filtered["Other"].length,0);modelGetCategorisedItemsStub.restore()});test("Should convert search term to lower case",function(){var modelGetCategorisedItemsStub=sinon.stub(this.model,"getCategorisedItems");modelGetCategorisedItemsStub.returns(this.mockCategorisedItems);var filtered=this.model.filterCategorisedItems("FISHEYE");equal(filtered["All"].length,1);equal(filtered["JIRA"].length,0);equal(filtered["Charts"].length,0);equal(filtered["Other"].length,1);modelGetCategorisedItemsStub.restore()});test("Should treat empty string as no filter",function(){var modelGetCategorisedItemsStub=sinon.stub(this.model,"getCategorisedItems");modelGetCategorisedItemsStub.returns(this.mockCategorisedItems);var filtered=this.model.filterCategorisedItems("");equal(filtered["All"].length,3);equal(filtered["JIRA"].length,2);equal(filtered["Charts"].length,1);equal(filtered["Other"].length,1);modelGetCategorisedItemsStub.restore()});test("Should return a map from category name to number of items in that category sorted by category name",function(){var modelGetCategorisedItemsStub=sinon.stub(this.model,"getCategorisedItems");modelGetCategorisedItemsStub.returns(this.mockCategorisedItems);var categoryCount=this.model.getCategoryCount();deepEqual(categoryCount,[{label:"All",count:3},{label:"Charts",count:1},{label:"JIRA",count:2},{label:"Other",count:1}]);modelGetCategorisedItemsStub.restore()});test("Should get a list of items that belong to the specified category",function(){var modelGetCategorisedItemsStub=sinon.stub(this.model,"getCategorisedItems");modelGetCategorisedItemsStub.returns(this.mockCategorisedItems);var itemsForCategory=this.model.getItemsForCategory("All");deepEqual(itemsForCategory,this.mockCategorisedItems["All"]);modelGetCategorisedItemsStub.restore()});test("Should update filtered categorised items when categorised items is updated",function(){var modelGetCategorisedItemsStub=sinon.stub(this.model,"getCategorisedItems");modelGetCategorisedItemsStub.returns(this.mockCategorisedItems);this.model.updateCategorisedItems();deepEqual(this.model.getCategorisedItems(),this.model.getFilteredCategorisedItems());modelGetCategorisedItemsStub.restore()});test("Should update filtered categorised items when categorised items is updated and taking into account existing search terms",function(){var modelGetCategorisedItemsStub=sinon.stub(this.model,"getCategorisedItems");modelGetCategorisedItemsStub.returns(this.mockCategorisedItems);this.model.set("searchText","FISHEYE");this.model.updateCategorisedItems();var filteredCategorisedItems=this.model.getFilteredCategorisedItems();equal(filteredCategorisedItems["All"].length,1);equal(filteredCategorisedItems["JIRA"].length,0);equal(filteredCategorisedItems["Charts"].length,0);equal(filteredCategorisedItems["Other"].length,1);modelGetCategorisedItemsStub.restore()});test("Should update filtered categorised items when search text is updated",function(){var modelGetCategorisedItemsStub=sinon.stub(this.model,"getCategorisedItems");modelGetCategorisedItemsStub.returns(this.mockCategorisedItems);deepEqual(this.model.getFilteredCategorisedItems(),{});this.model.setSearchText("hipchat");var filteredCategorisedItems=this.model.getFilteredCategorisedItems();equal(filteredCategorisedItems["All"].length,0);equal(filteredCategorisedItems["JIRA"].length,0);equal(filteredCategorisedItems["Charts"].length,0);equal(filteredCategorisedItems["Other"].length,0);this.model.setSearchText("");deepEqual(this.model.getCategorisedItems(),this.model.getFilteredCategorisedItems());modelGetCategorisedItemsStub.restore()});test("Should update filtered categorised items when search text is updated",function(){var modelGetCategorisedItemsStub=sinon.stub(this.model,"getCategorisedItems");modelGetCategorisedItemsStub.returns({});deepEqual(this.model.getFilteredCategorisedItems(),{});this.model.setSearchText("hipchat");deepEqual(this.model.getFilteredCategorisedItems(),{});this.model.setSearchText("");deepEqual(this.model.getFilteredCategorisedItems(),{});modelGetCategorisedItemsStub.restore()});test("Should update categorised items when more data is being rendered",function(){var stub=sinon.stub(this.model,"updateCategorisedItems");this.model.loadUnrenderedData();ok(stub.calledOnce);stub.restore()});test("Should trigger data update event when more data is being rendered",function(){var spy=sinon.spy();this.model.on("dataUpdate",spy);this.model.loadUnrenderedData();ok(spy.calledOnce)});test("Should trigger message update event when more data is being rendered",function(){var spy=sinon.spy();this.model.on("messageUpdate",spy);this.model.loadUnrenderedData();ok(spy.calledOnce)});test("Should reset has unrendered data to false when more data is being rendered",function(){this.model.loadUnrenderedData();ok(!this.model.get("hasUnrenderedData"))});test("Should re-initialized states when directory items throws reset event",function(){this.model.set({retrievalInProgress:true,retrievalFailed:true,hasUnrenderedData:true,directoryIsVisible:true,searchText:"duck",selectedCategory:"JIRA",categorisedItems:{"All":[]},filteredCategorisedItems:{"All":[]}});this.model.directoryItems.trigger("reset");ok(!this.model.get("retrievalInProgress"));ok(!this.model.get("retrievalFailed"));ok(!this.model.get("hasUnrenderedData"));ok(!this.model.get("directoryIsVisible"));equal(this.model.get("searchText"),"");equal(this.model.get("selectedCategory"),"All");deepEqual(this.model.get("categorisedItems"),{});deepEqual(this.model.get("filteredCategorisedItems"),{})})});