AJS.test.require(["jira.webresources:legacy-namespacing","com.atlassian.gadgets.dashboard.refimpl.ui:required-libraries","com.atlassian.gadgets.dashboard:dashboard-test"],function(){module("Directory items test",{setup:function(){this.retriever=new JIRA.Dashboard.Services.ItemRetriever();this.items=new JIRA.Dashboard.Entities.DirectoryItems([],{retriever:this.retriever});this.onRetrieving=sinon.spy();this.items.on("retrieving",this.onRetrieving);this.onRetrieve=sinon.spy();this.items.on("retrieve",this.onRetrieve);this.handleRetrieveFailure=sinon.spy();this.items.on("retrieveFailure",this.handleRetrieveFailure);this.server=sinon.fakeServer.create();this.serverResponse=[{"id":"rest/gadgets/1.0/g/com.atlassian.jira.gadgets:introduction-gadget/gadgets/introduction-gadget.xml","titleLabel":"Introduction","titleUri":"","authorLabel":"Atlassian","description":"An introduction to this installation of JIRA.","specUri":"rest/gadgets/1.0/g/com.atlassian.jira.gadgets:introduction-gadget/gadgets/introduction-gadget.xml","categories":["JIRA"],"thumbnailUri":"http://esukmajaya:2990/jira/s/en_USyq5hb4/6327/3/6.3-OD-07-001/_/download/resources/com.atlassian.jira.gadgets:introduction-gadget/text-thumb.png"},{"id":"rest/gadgets/1.0/g/com.atlassian.jira.gadgets:time-since-chart-gadget/gadgets/timesince-gadget.xml","titleLabel":"Time Since Chart","titleUri":"","authorLabel":"Atlassian","description":"Displays the time since a chosen field for each issue for a project or saved filter.","specUri":"rest/gadgets/1.0/g/com.atlassian.jira.gadgets:time-since-chart-gadget/gadgets/timesince-gadget.xml","categories":["Charts","JIRA"],"thumbnailUri":"http://esukmajaya:2990/jira/s/en_USyq5hb4/6327/3/6.3-OD-07-001/_/download/resources/com.atlassian.jira.gadgets:time-since-chart-gadget/timeSince-thumb.png"},{"id":"https://jira.atlassian.com/rest/gadgets/1.0/g/com.atlassian.jirafisheyeplugin:fisheye-recent-commits-gadget/gadgets/fisheye-recent-commits-gadget.xml","titleLabel":"__MSG_gadget.fisheye.recentcommits.title__","titleUri":"","authorLabel":"Atlassian","description":"__MSG_gadget.fisheye.recentcommits.description__","specUri":"https://jira.atlassian.com/rest/gadgets/1.0/g/com.atlassian.jirafisheyeplugin:fisheye-recent-commits-gadget/gadgets/fisheye-recent-commits-gadget.xml","categories":["Other"],"thumbnailUri":"http://esukmajaya:2990/jira/s/en_USyq5hb4/6327/3/6.3.2/_/download/resources/com.atlassian.jirafisheyeplugin:fisheye-recent-commits-gadget/fisheyeRecentCommits-thumb.png"}];this.constantsStub=sinon.stub(JIRA.Dashboard.Directory.Constants,"getDefaultCategoryName").returns("All")},teardown:function(){this.server.restore();this.constantsStub.restore()}});test("should respond with correct initial states",function(){ok(!this.items.isReady(),"Items should not be ready.");ok(!this.items.retrievalStarted(),"Retrieval should not have been started.");ok(!this.items.retrievalInProgress(),"Retrieval should not be in progress.");ok(!this.items.retrievalCompleted(),"Retrieval should not be completed.")});test("should indicate retrieval in progress when retrieval is in progress",function(){this.items.retrieve();ok(!this.items.isReady(),"Items should not be ready.");ok(this.items.retrievalStarted(),"Retrieval should have been started.");ok(this.items.retrievalInProgress(),"Retrieval should be in progress.");ok(!this.items.retrievalCompleted(),"Retrieval should not be completed.")});test("should trigger no events when retrieve has not been invoked",function(){ok(!this.onRetrieving.called,"Retrieving handler should not be called.");ok(!this.onRetrieve.called,"Retrieve handler should not be called.");ok(!this.handleRetrieveFailure.called,"Retrieve failure handler should not be called.")});test("should categorise items",function(){this.retriever.trigger("retrieve",this.serverResponse);equal(this.items.getCategorisedItems()["All"].length,3);equal(this.items.getCategorisedItems()["Charts"].length,1);equal(this.items.getCategorisedItems()["JIRA"].length,2);equal(this.items.getCategorisedItems()["Other"].length,1)});test("Should throw batchRetrieving event when retrieve is trigger",function(){var onBatchRetrieving=sinon.spy();this.items.on("batchRetrieving",onBatchRetrieving);var onBatchRetrieveComplete=sinon.spy();this.items.on("batchRetrieveComplete",onBatchRetrieveComplete);this.items.retrieve();ok(onBatchRetrieving.called);ok(!onBatchRetrieveComplete.called)});test("Should reset states and trigger reset event when reset is invoked",function(){var stub=sinon.stub(this.items.retriever,"reset");this.items.categorisedItems={"All":[]};this.items.set([new JIRA.Dashboard.Entities.DirectoryItem()]);var spy=sinon.spy();this.items.on("reset",spy);this.items.reset();ok(stub.calledOnce);deepEqual(this.items.getCategorisedItems(),{});equal(this.items.models.length,0);ok(spy.calledOnce);stub.restore()});test("Should retry failed endpoints",function(){this.items.retriever.inProgressUrls=[];this.items.retriever.failedUrls=["/failed/url"];var spy=sinon.spy();this.items.on("batchRetrieving",spy);this.items.retryFailedEndpoints();equal(this.items.retriever.failedUrls.length,0);equal(this.items.retriever.inProgressUrls.length,1);ok(spy.calledOnce);equal(this.server.requests.length,1)});test("Should transform response data",function(){var transformStub=sinon.stub(this.items,"transformResponseData");transformStub.returns([1,2,3]);var setStub=sinon.stub(this.items,"set");this.items.retrieve();this.server.requests[0].respond(200,{"Content-Type":"application/json"},JSON.stringify(this.serverResponse));ok(transformStub.calledOnce);ok(transformStub.calledWith(this.serverResponse));ok(setStub.calledOnce);ok(setStub.calledWith([1,2,3]));transformStub.restore();setStub.restore()});test("Transform response data should append an attribute that indicate whether a gadget is local",function(){var transformed=this.items.transformResponseData(this.serverResponse);equal(transformed.length,3);equal(transformed[0].isLocal,true);equal(transformed[1].isLocal,true);equal(transformed[2].isLocal,false)});test("Should introduce specUriDisplay property in the transformed data",function(){var stub=sinon.stub(AG.param,"get");stub.returns("http://localhost:2990/");var transformed=this.items.transformResponseData(this.serverResponse);equal(transformed.length,3);equal(transformed[0].specUri,"rest/gadgets/1.0/g/com.atlassian.jira.gadgets:introduction-gadget/gadgets/introduction-gadget.xml");equal(transformed[0].specUriDisplay,"http://localhost:2990/rest/gadgets/1.0/g/com.atlassian.jira.gadgets:introduction-gadget/gadgets/introduction-gadget.xml");equal(transformed[1].specUri,"rest/gadgets/1.0/g/com.atlassian.jira.gadgets:time-since-chart-gadget/gadgets/timesince-gadget.xml");equal(transformed[1].specUriDisplay,"http://localhost:2990/rest/gadgets/1.0/g/com.atlassian.jira.gadgets:time-since-chart-gadget/gadgets/timesince-gadget.xml");equal(transformed[2].specUri,"https://jira.atlassian.com/rest/gadgets/1.0/g/com.atlassian.jirafisheyeplugin:fisheye-recent-commits-gadget/gadgets/fisheye-recent-commits-gadget.xml");equal(transformed[2].specUriDisplay,"https://jira.atlassian.com/rest/gadgets/1.0/g/com.atlassian.jirafisheyeplugin:fisheye-recent-commits-gadget/gadgets/fisheye-recent-commits-gadget.xml");stub.restore()})});