AJS.test.require([
    "jira.webresources:legacy-namespacing",
    "com.atlassian.gadgets.dashboard.refimpl.ui:required-libraries",
    "com.atlassian.gadgets.dashboard:dashboard-test"
], function(){
    module("Dashboard service test", {
        setup: function() {
            var layout = {
                getGadgets: function() {}
            };
            this.layoutStub = sinon.stub(AG.DashboardManager, "getLayout");
            this.layoutStub.returns(layout);
            this.getGadgetsStub = sinon.stub(layout, "getGadgets");
            this.paramGetStub = sinon.stub(AG.param, "get");
            this.cookieEraseStub = sinon.stub(AG.Cookie, "erase");
            this.addGagetStub = sinon.stub(AG.DashboardManager, "addGadget");

            this.prevColumnValue = AJS.activeColumn;
            AJS.activeColumn = 2;

            this.server = sinon.fakeServer.create();
            this.serverSuccessResponse = {
                id: 13,
                field1: "value1"
            }

            this.service = JIRA.Dashboard.DashboardService;
        },

        teardown: function() {
            this.layoutStub.restore();
            this.getGadgetsStub.restore();
            this.paramGetStub.restore();
            this.cookieEraseStub.restore();
            this.addGagetStub.restore();

            AJS.activeColumn = this.prevColumnValue;

            this.server.restore();
        }
    });

    test("Should invoke error callback when number of gadgets exceeds maximum allowed gadgets", function(){
        this.getGadgetsStub.returns([1,2,3,4,5]);
        this.paramGetStub.withArgs("maxGadgets").returns(3);

        var successCallback = sinon.spy();
        var errorCallback = sinon.spy();
        this.service.addItem("item-url", {
            onSuccess: successCallback,
            onError: errorCallback
        });

        ok(!successCallback.called);
        ok(errorCallback.calledOnce);
    });

    test("Should make AJAX call with the right parameters", function(){
        this.getGadgetsStub.returns([1,2,3,4,5]);
        this.paramGetStub.withArgs("maxGadgets").returns(10);
        this.paramGetStub.withArgs("dashboardResourceUrl").returns("dashboard-resource-url");

        var successCallback = sinon.spy();
        var errorCallback = sinon.spy();
        this.service.addItem({
            id: 1,
            type: "gadget"
        }, {
            onSuccess: successCallback,
            onError: errorCallback
        });

        var request = this.server.requests[0];
        equal(request.method, "POST");
        equal(request.url, "dashboard-resource-url.json?");
        equal(request.requestBody, "{\"dashboardItemId\":1,\"type\":\"gadget\",\"columnIndex\":2}")

        ok(!successCallback.called);
        ok(!errorCallback.called);

    });

    test("Should add gadget to the dashboard when AJAX call succeeded", function(){
        this.getGadgetsStub.returns([1,2,3,4,5]);
        this.paramGetStub.withArgs("maxGadgets").returns(10);
        this.paramGetStub.withArgs("dashboardResourceUrl").returns("dashboard-resource-url");

        var successCallback = sinon.spy();
        var errorCallback = sinon.spy();
        this.service.addItem("item-url", {
            onSuccess: successCallback,
            onError: errorCallback
        });

        this.server.requests[0].respond(200, {"Content-Type": "application/json"}, JSON.stringify(this.serverSuccessResponse));

        ok(this.cookieEraseStub.calledOnce);
        ok(this.cookieEraseStub.calledWith("gadget-13-fh"));
        ok(this.addGagetStub.calledOnce)
        equal(this.addGagetStub.firstCall.args.length, 2);
        deepEqual(this.addGagetStub.firstCall.args[0], this.serverSuccessResponse);
        equal(this.addGagetStub.firstCall.args[1], 2);
    });

    test("Should invoke success callback when AJAX call succeded", function(){
        this.getGadgetsStub.returns([1,2,3,4,5]);
        this.paramGetStub.withArgs("maxGadgets").returns(10);
        this.paramGetStub.withArgs("dashboardResourceUrl").returns("dashboard-resource-url");

        var successCallback = sinon.spy();
        var errorCallback = sinon.spy();
        this.service.addItem("item-url", {
            onSuccess: successCallback,
            onError: errorCallback
        });

        this.server.requests[0].respond(200, {"Content-Type": "application/json"}, JSON.stringify(this.serverSuccessResponse));

        ok(successCallback.calledOnce);
        ok(!errorCallback.called);
    });

    test("Should not add gadget to the dashboard when AJAX call failed", function(){
        this.getGadgetsStub.returns([1,2,3,4,5]);
        this.paramGetStub.withArgs("maxGadgets").returns(10);
        this.paramGetStub.withArgs("dashboardResourceUrl").returns("dashboard-resource-url");

        var successCallback = sinon.spy();
        var errorCallback = sinon.spy();
        this.service.addItem("item-url", {
            onSuccess: successCallback,
            onError: errorCallback
        });

        this.server.requests[0].respond(500);

        ok(!this.addGagetStub.called)
    });

    test("Should invoke error callback when AJAX call failed", function(){
        this.getGadgetsStub.returns([1,2,3,4,5]);
        this.paramGetStub.withArgs("maxGadgets").returns(10);
        this.paramGetStub.withArgs("dashboardResourceUrl").returns("dashboard-resource-url");

        var successCallback = sinon.spy();
        var errorCallback = sinon.spy();
        this.service.addItem("item-url", {
            onSuccess: successCallback,
            onError: errorCallback
        });

        this.server.requests[0].respond(500);

        ok(!successCallback.called);
        ok(errorCallback.calledOnce);
    });
});