AJS.test.require([
    "jira.webresources:legacy-namespacing",
    "com.atlassian.gadgets.dashboard.refimpl.ui:required-libraries",
    "com.atlassian.gadgets.dashboard:dashboard-test"
], function(){
    module("Dashboard item directory test", {
        setup: function() {
            this.onDashboardItemAddSpy = sinon.spy(JIRA.Dashboard.Modules.Directory.prototype, "onDashboardItemAdd");

            this.dashboardServiceStub = sinon.stub(JIRA.Dashboard.DashboardService, "addItem");
            this.controllerEnableButtonsStub = sinon.stub(JIRA.Dashboard.Controllers.DirectoryLoader.prototype, "enableDirectoryAddButtons");
            this.controllerDisableButtonsStub = sinon.stub(JIRA.Dashboard.Controllers.DirectoryLoader.prototype, "disableDirectoryAddButtons");
            this.dialogControllerGetDirectoryControllerStub = sinon.stub(JIRA.Dashboard.Controllers.DialogController.prototype, "getDirectoryController");
            this.dialogControllerGetDirectoryControllerStub.returns(_.extend({}, Backbone.Events));

            this.directoryModule = new JIRA.Dashboard.Modules.Directory({live: function(){}});
        },

        teardown: function() {
            this.onDashboardItemAddSpy.restore();

            this.dashboardServiceStub.restore();
            this.controllerEnableButtonsStub.restore();
            this.controllerDisableButtonsStub.restore();
            this.dialogControllerGetDirectoryControllerStub.restore();
        }
    });

    test("Should listen to dashboard item add thrown by controller", function(){
        this.directoryModule.controller.trigger("dashboardItemAdd");

        ok(this.onDashboardItemAddSpy.calledOnce);
    });

    test("On dashboard item add should disable all buttons and invoke dashboard service", function(){
        this.directoryModule.onDashboardItemAdd("item-url");

        ok(this.controllerDisableButtonsStub.calledOnce);
        ok(this.controllerDisableButtonsStub.calledOn(this.directoryModule.controller));
        ok(this.dashboardServiceStub.calledOnce);
        equal(this.dashboardServiceStub.lastCall.args[0], "item-url");
    });

    test("Dashboard service success callback should enable add buttons", function(){
        this.directoryModule.onDashboardItemAdd("item-url");
        var callback = this.dashboardServiceStub.lastCall.args[1];

        callback.onSuccess();

        ok(this.controllerEnableButtonsStub.calledOnce);
        ok(this.controllerEnableButtonsStub.calledOn(this.directoryModule.controller));
    });

    test("Dashboard service error callback should enable add buttons", function(){
        this.directoryModule.onDashboardItemAdd("item-url");
        var callback = this.dashboardServiceStub.lastCall.args[1];

        callback.onError();

        ok(this.controllerEnableButtonsStub.calledOnce);
        ok(this.controllerEnableButtonsStub.calledOn(this.directoryModule.controller));
    });
});