AJS.test.require([
    "jira.webresources:legacy-namespacing",
    "com.atlassian.gadgets.dashboard.refimpl.ui:required-libraries",
    "com.atlassian.gadgets.dashboard:dashboard-test"
], function(){
    module("Dialog controller test", {
        setup: function() {
            this.loadingViewRenderStub = sinon.stub(JIRA.Dashboard.Views.DirectoryLoadingView.prototype, "render");
            this.loadingViewDetachStub = sinon.stub(JIRA.Dashboard.Views.DirectoryLoadingView.prototype, "detach");
            this.loadFailureViewRenderStub = sinon.stub(JIRA.Dashboard.Views.DirectoryLoadFailureView.prototype, "render");
            this.loadFailureViewDetachStub = sinon.stub(JIRA.Dashboard.Views.DirectoryLoadFailureView.prototype, "detach");
            this.directoryControllerRenderStub = sinon.stub(JIRA.Dashboard.Controllers.DirectoryController.prototype, "render");
            this.directoryControllerDetachStub = sinon.stub(JIRA.Dashboard.Controllers.DirectoryController.prototype, "detach");
            this.sinonParamGetStub = sinon.stub(AG.param, "get");

            this.model = new JIRA.Dashboard.Entities.DirectoryItems([], {
                retriever: new JIRA.Dashboard.Services.ItemRetriever()
            });
            this.controller = new JIRA.Dashboard.Controllers.DialogController(this.model, "my-dialog");

            this.detachCurrentPageSpy = sinon.spy(this.controller, "detachCurrentPage");
        },

        teardown: function() {
            this.loadingViewRenderStub.restore();
            this.loadingViewDetachStub.restore();
            this.loadFailureViewRenderStub.restore();
            this.loadFailureViewDetachStub.restore();
            this.detachCurrentPageSpy.restore();
            this.directoryControllerRenderStub.restore();
            this.directoryControllerDetachStub.restore();
            this.sinonParamGetStub.restore();

            this.controller.destroyDialog();
        }
    });

    test("Should render directory loading view when asked to show loading page and current page is not the loading page", function() {
        this.controller.dialogVisible = false;
        this.controller.currentPage = "loadFailure";

        this.controller.showDirectoryLoadingPage();

        ok(this.detachCurrentPageSpy.calledOnce);
        ok(this.loadingViewRenderStub.calledOnce);
        ok(this.loadingViewRenderStub.calledOn(this.controller.loadingView));
    });

    test("Should show dialog when asked to show loading page and dialog is not visible", function(){
        this.controller.dialogVisible = false;
        this.controller.currentPage = "loadFailure";
        this.controller.showDirectoryLoadingPage();

        equal(AJS.$("#my-dialog").attr("aria-hidden"), "false");
        ok(this.controller.dialogVisible);
    });

    test("Should not render directory loading view when asked to show loading page and current page is the loading page", function(){
        this.controller.dialogVisible = true;
        this.controller.currentPage = "loading";
        this.controller.showDirectoryLoadingPage();

        ok(!this.detachCurrentPageSpy.called);
        ok(!this.loadingViewRenderStub.called);
    });

    test("Should not show dialog when asked to show loading page and dialog is already visible", function() {
        this.controller.dialogVisible = true;
        this.controller.currentPage = "loading";
        var spy = sinon.spy(this.controller, "showDialog");

        this.controller.showDirectoryLoadingPage();

        ok(!spy.called);
        spy.restore();
    });

    test("Should render directory view when asked to show directory page and current page is not the directory page", function(){
        this.controller.dialogVisible = false;
        this.controller.currentPage = "loading";

        this.controller.showDirectory();

        ok(this.detachCurrentPageSpy.calledOnce);
        ok(this.directoryControllerRenderStub.calledOnce);
        ok(this.directoryControllerRenderStub.calledOn(this.controller.directoryController));
    });

    test("Should show dialog when asked to show directory page and dialog is not visible", function(){
        this.controller.dialogVisible = false;
        this.controller.currentPage = "loading";

        this.controller.showDirectory();

        equal(AJS.$("#my-dialog").attr("aria-hidden"), "false");
        ok(this.controller.dialogVisible);
    });


    test("Should not render directory view when asked to show directory page and current page is the directory page", function(){
        this.controller.dialogVisible = true;
        this.controller.currentPage = "directory";

        this.controller.showDirectory();

        ok(!this.detachCurrentPageSpy.called);
        ok(!this.directoryControllerRenderStub.called);
    });

    test("Should not show dialog when asked to show directory page and dialog is already visible", function(){
        this.controller.dialogVisible = true;
        this.controller.currentPage = "directory";
        var spy = sinon.spy(this.controller, "showDialog");

        this.controller.showDirectory();

        ok(!spy.called);
        spy.restore();
    });

    test("Should render directory load failure view when asked to show directory load failure page and current page is not the directory load failure page", function(){
        this.controller.dialogVisible = false;
        this.controller.currentPage = "loading";

        this.controller.showDirectoryLoadFailurePage();

        ok(this.detachCurrentPageSpy.calledOnce);
        ok(this.loadFailureViewRenderStub.calledOnce);
        ok(this.loadFailureViewRenderStub.calledOn(this.controller.loadFailureView));
    });

    test("Should show dialog when asked to show directory load failure page and dialog is not visible", function(){
        this.controller.dialogVisible = false;
        this.controller.currentPage = "loading";

        this.controller.showDirectoryLoadFailurePage();

        equal(AJS.$("#my-dialog").attr("aria-hidden"), "false");
        ok(this.controller.dialogVisible);
    });

    test("Should not render directory load failure view when asked to show directory load failure page and current page is the directory load failure page", function(){
        this.controller.dialogVisible = true;
        this.controller.currentPage = "loadFailure";
        this.controller.showDirectoryLoadFailurePage();

        ok(!this.detachCurrentPageSpy.called);
        ok(!this.loadFailureViewRenderStub.called);
    });

    test("Should not show dialog when asked to show directory load failure page page and dialog is already visible", function(){
        this.controller.dialogVisible = true;
        this.controller.currentPage = "loadFailure";
        var spy = sinon.spy(this.controller, "showDialog");

        this.controller.showDirectoryLoadFailurePage();

        ok(!spy.called);
        spy.restore();
    });

    test("Should listen to dialog close event", function(){
        this.controller.showDialog();
        ok(this.controller.dialogVisible);

        this.controller.dialog.hide();

        ok(!this.controller.dialogVisible);
    });

    test("Should delegate to loading view when asked to detach the loading page", function(){
        this.controller.currentPage = "loading";

        this.controller.detachCurrentPage();

        ok(this.loadingViewDetachStub.calledOnce);
        ok(this.loadingViewDetachStub.calledOn(this.controller.loadingView));
    });

    test("Should delegate to loading failure view when asked to detach the load failure page", function(){
        this.controller.currentPage = "loadFailure";

        this.controller.detachCurrentPage();

        ok(this.loadFailureViewDetachStub.calledOnce);
        ok(this.loadFailureViewDetachStub.calledOn(this.controller.loadFailureView));
    });

    test("Should delegate to directory controller when asked to detach the directory page", function(){
        this.controller.currentPage = "directory";

        this.controller.detachCurrentPage();

        ok(this.directoryControllerDetachStub.calledOnce);
        ok(this.directoryControllerDetachStub.calledOn(this.controller.directoryController));
    });

    test("Should do nothing when asked to detach empty page", function(){
        this.controller.currentPage = "";

        this.controller.detachCurrentPage();
        expect(0);
    });

    test("Should propagate directoryReloadRequest event", function(){
        var spy = sinon.spy();
        this.controller.on("directoryReloadRequest", spy);

        this.controller.loadFailureView.trigger("directoryReloadRequest");

        ok(spy.calledOnce);
    });

    test("Should invoke reset user input on directory controller when resetUserInputOnCurrentPage and current page is directory", function(){
        var stub = sinon.stub(this.controller.directoryController, "resetUserInput");

        this.controller.currentPage = "directory";
        this.controller.resetUserInputOnCurrentPage();

        ok(stub.calledOnce);
        stub.restore();
    });

    test("Should not invoke reset user input on directory controller when resetUserInputOnCurrentPage and current page is not directory", function(){
        var stub = sinon.stub(this.controller.directoryController, "resetUserInput");

        this.controller.currentPage = "loading";
        this.controller.resetUserInputOnCurrentPage();

        ok(!stub.called);
        stub.restore();
    });

    test("Should show admin link when the user is authorised", function(){
        this.sinonParamGetStub.withArgs("canAddExternalGadgetsToDirectory").returns(true);
        this.controller = new JIRA.Dashboard.Controllers.DialogController(this.model, "my-dialog");

        this.controller.showDirectory();

        equal(AJS.$("#my-dialog").find("div.aui-dialog2-header-secondary").length, 1);
    });

    test("Should not show admin link when the user is not authorised", function(){
        this.sinonParamGetStub.withArgs("canAddExternalGadgetsToDirectory").returns(false);
        this.controller = new JIRA.Dashboard.Controllers.DialogController(this.model, "my-dialog");

        this.controller.showDirectory();

        equal(AJS.$("#my-dialog").find("div.aui-dialog2-header-secondary").length, 0);
    });
});