AJS.namespace("JIRA.Dashboard.DashboardService");

JIRA.Dashboard.DashboardService = {
    addItem: function(directoryItem, callback) {
        if (AG.DashboardManager.getLayout().getGadgets().length >= AG.param.get("maxGadgets")) {
            callback.onError(AJS.I18n.getText("dashboard.error.too.many.gadgets"));
            return;
        }

        var dashboardResourceUrl = AG.param.get("dashboardResourceUrl");
        var localeLang = AJS.$('.locale-lang','#i18n-settings').val();
        var localeCountry = AJS.$('.locale-country','#i18n-settings').val();
        AJS.$.ajax({
            type: "POST",
            url: dashboardResourceUrl + ".json?" + (localeLang ? "locale.lang="+localeLang : "") + (localeCountry ? "&locale.country="+localeCountry : ""),
            contentType: "application/json",
            dataType: "json",
            data: JSON.stringify({
                dashboardItemId: directoryItem.id,
                type: directoryItem.type,
                columnIndex: AJS.activeColumn
            }),
            processData: false,
            success: function(data) {
                AG.Cookie.erase("gadget-" + data.id + "-fh");
                AG.DashboardManager.addGadget(data, AJS.activeColumn);
                callback.onSuccess();
            },
            error: function(request, textStatus, errorThrown) {
                console.error("DashboardService: Failed to add item to the dashboard. Reason: " + errorThrown);
                callback.onError();
            }
        });
    }
};