;(function() {

    var API = function(gadget) {
        this.gadget = gadget;
        this.publicInstace = gadget.getPublicInstance && gadget.getPublicInstance(); // API can be created with gadgets that don't provide public instance (e.g. by other plugins like Wallboard)
    };

    var resize = function(API) {
        if (API.publicInstace) {
            API.publicInstace.resize();
        }
    };

    _.extend(API.prototype, Backbone.Events, {

        /**
         * @event expand
         */

        /**
         * @event restore
         */

        /**
         * @event minimize
         */

        /**
         * @event maximize
         */

        /**
         * @event remove
         */

        /**
         * @event dragStart
         */

        /**
         * @event dragStop
         */

        /**
         * @event afterRender
         */

        /**
         * Check if a dashboard item is configurable and if the current user has permission to edit this
         * dashboard item's configuration.
         * @returns {boolean} true if the current user can edit the gaget
         */
        isEditable: function() {
            return this.gadget.isEditable();
        },

        _preparePreferencesToBeSaved: function(preferences) {
            var userPreferences = {};

            userPreferences["up_isConfigured"] = true;
            _.each(preferences, function(value, name) {
                userPreferences["up_"+name] = String(value);
            });

            return userPreferences;
        },

        /**
         * Helper to extract the correct value to be persisted for a refresh field rendered with .refreshInterval
         * @param {string} [fieldName=refresh] - Refresh field name, defaults to "refresh"
         * @returns {string} value that should be persisted as preference
         */
        getRefreshFieldValue: function(fieldName) {
            fieldName = fieldName || 'refresh';

            var input = this.gadget.$.find('input[name=' + fieldName + ']');
            return input.is(':checked') ? input.val() : 'false';
        },

        /**
         * Tries to save the passed preferences on the server for this dashboard item.
         * If the user doesn't have permission to edit this dashboard item, no action will be performed.
         *
         * @fires AG.InlineGadgetAPI#preferencesSaved
         * @fires AG.InlineGadgetAPI#error:preferencesSaved
         * @param {Object} preferences the new preferences object to save for this dashboard item
         */
        savePreferences: function(preferences) {
            if(!this.isEditable()) {
                this.trigger("error:preferencesSaved");
                return;
            }
            return AJS.$.ajax({
                url: this.gadget.userPrefs.action,
                type: "PUT",
                contentType: "application/json",
                data: JSON.stringify(this._preparePreferencesToBeSaved(preferences))
            })
                .done(_.bind(function() {
                    AJS.$.ajax({
                        url: this.gadget.userPrefs.action,
                        type: "GET",
                        dataType: "json"
                    })
                        .done(_.bind(function(results) {
                            this.trigger("preferencesSaved", results.fields);
                        }, this))
                        .fail(_.bind(function(){
                            this.trigger("error:preferencesSaved");
                        }, this));
                }, this))
                .fail(_.bind(function(){
                    this.trigger("error:preferencesSaved");
                }, this));
        },

        setTitle: function(title) {
            if (!this.gadget.$) {
                return; // The gadget has not been rendered yet.
            }
            this.gadget.$.find('.dashboard-item-title').text(title);
        },

        initRefresh: function(preferences, cb) {
            if(this.gadget.refreshIntervalId) {
                clearInterval(this.gadget.refreshIntervalId);
            }
            if(!isNaN(parseInt(preferences.refresh))) {
                var refreshIntervalMillis = parseInt(preferences.refresh) * 60000;
                this.gadget.refreshIntervalId = setInterval(cb, refreshIntervalMillis);
            }
        },

        showLoadingBar: function() {
            if (!this.gadget.$) {
                return; // The gadget has not been rendered yet.
            }

            var self = this;
            if (!this.gadget.showLoadingBarTimeoutId) {
                this.gadget.showLoadingBarTimeoutId = setTimeout(function () {
                    var $gadgetContainer = self.gadget.$.find('#gadget-' + self.gadget.id);
                    var cls = $gadgetContainer.width() < 250 ? 'loading-small' : 'loading';
                    self.$loadingBar = AJS.$('<div class="' + cls + '"></div>');
                    self.$loadingBar.height(Math.max(40, $gadgetContainer.height()));
                    $gadgetContainer.after(self.$loadingBar);
                    $gadgetContainer.addClass('hidden');
                    self.forceLayoutRefresh();
                }, 1000);
            }
        },

        hideLoadingBar: function () {
            //clear any loading bars waiting to show;
            if (this.gadget.showLoadingBarTimeoutId) {
                clearTimeout(this.gadget.showLoadingBarTimeoutId);
                delete this.gadget.showLoadingBarTimeoutId;
            }
            if (!this.$loadingBar) {
                return; // 'showLoadingBar' has not been called
            }
            if (!this.gadget.$) {
                return; // The gadget has not been rendered yet.
            }

            this.$loadingBar.detach();
            this.$loadingBar = null;
            this.gadget.$.find('#gadget-' + this.gadget.id).removeClass('hidden');
            this.forceLayoutRefresh();
        },

        getContext: function() {
          return this.gadget.context;
        },

        closeEdit: function() {
            this.trigger("close-edit");
        },

        /**
         * This method is deprecated. You should have no reason to refresh the layout.
         * Use API.resize() to resize your item if needed.
         */
        forceLayoutRefresh: function() {
            console.warn('forceLayoutRefresh() is deprecated. Use resize() instead.');
            resize(this); // in the former API there was no scroll on overflow, so layout refresh was all that was needed to make things work, but now this is equivalent to resize()
        },

        getGadgetId: function() {
            return this.gadget.id;
        },

        /**
         * When you add some content dynamically to your dashboard item and it causes the height to increase a scroll will appear.
         * Call this method to resize the content automatically and make the scroll go away.
         */
        resize: function() {
            resize(this);
        }
    });

    AG = window.AG || {};
    AG.InlineGadgetAPI = API;
})();
