window.AG = window.AG || {};

/**
 * Create a native event object.
 *
 * @example
 *
 *     var initialised = AG.DOMEvent("initialised");
 *     document.querySelector("#dashboard").dispatchEvent(initialised);
 *
 * @param name
 * @returns {Event} a native event object
 * @constructor
 *
 * @requires
 *
 *     AG.window.js
 */
AG.DOMEvent = function (name) {
    var window = AG.window;
    var event;

    if (typeof window.Event === "function") {
        event = new window.Event(name);
    } else {
        event = window.document.createEvent("HTMLEvents");
        event.initEvent(name, true, false); // name, bubbles, cancelable
    }

    return event;
};
