/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.gadgets.dashboard.internal.velocity;

import com.atlassian.gadgets.GadgetRequestContext;
import com.atlassian.gadgets.dashboard.DashboardState;
import com.atlassian.gadgets.dashboard.DashboardTab;
import com.atlassian.gadgets.dashboard.internal.DashboardUrlBuilder;
import com.atlassian.gadgets.dashboard.internal.DashboardWebItemFinder;
import com.atlassian.gadgets.dashboard.internal.StateConverter;
import com.atlassian.gadgets.dashboard.internal.Tab;
import com.atlassian.gadgets.dashboard.internal.impl.TabImpl;
import com.atlassian.gadgets.dashboard.internal.velocity.DashboardEmbedder;
import com.atlassian.gadgets.dashboard.internal.velocity.DashboardView;
import com.atlassian.gadgets.dashboard.spi.DashboardPermissionService;
import com.atlassian.gadgets.dashboard.view.DashboardTabViewFactory;
import com.atlassian.gadgets.directory.spi.DirectoryPermissionService;
import com.atlassian.gadgets.view.ViewComponent;
import com.atlassian.plugin.spring.scanner.annotation.export.ExportAsService;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.plugin.webresource.WebResourceManager;
import com.atlassian.sal.api.message.I18nResolver;
import com.atlassian.soy.renderer.SoyTemplateRenderer;
import com.google.common.base.Preconditions;
import java.util.ArrayList;
import javax.annotation.Nullable;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@ExportAsService(value={DashboardTabViewFactory.class})
@Component(value="dashboardTabViewFactory")
public class VelocityViewFactory
implements DashboardTabViewFactory {
    private final SoyTemplateRenderer renderer;
    private final DashboardPermissionService dashboardPermissionService;
    private final DirectoryPermissionService directoryPermissionService;
    private final StateConverter stateConverter;
    private final DashboardEmbedder dashboardEmbedder;
    private final DashboardWebItemFinder webItemFinder;
    private final DashboardUrlBuilder urlBuilder;
    private final I18nResolver i18n;
    private final WebResourceManager webResourceManager;

    @Autowired
    public VelocityViewFactory(@ComponentImport SoyTemplateRenderer renderer, StateConverter stateConverter, @ComponentImport DashboardPermissionService dashboardPermissionService, @ComponentImport DirectoryPermissionService directoryPermissionService, DashboardEmbedder dashboardEmbedder, DashboardWebItemFinder webItemFinder, DashboardUrlBuilder urlBuilder, @ComponentImport I18nResolver i18n, @ComponentImport WebResourceManager webResourceManager) {
        this.renderer = (SoyTemplateRenderer)Preconditions.checkNotNull((Object)renderer, (Object)"renderer");
        this.stateConverter = (StateConverter)Preconditions.checkNotNull((Object)stateConverter, (Object)"stateConverter");
        this.dashboardPermissionService = (DashboardPermissionService)Preconditions.checkNotNull((Object)dashboardPermissionService, (Object)"dashboardPermissionService");
        this.directoryPermissionService = (DirectoryPermissionService)Preconditions.checkNotNull((Object)directoryPermissionService, (Object)"directoryPermissionService");
        this.dashboardEmbedder = (DashboardEmbedder)Preconditions.checkNotNull((Object)dashboardEmbedder, (Object)"dashboardEmbedder");
        this.webItemFinder = (DashboardWebItemFinder)((Object)Preconditions.checkNotNull((Object)((Object)webItemFinder), (Object)"webItemFinder"));
        this.i18n = (I18nResolver)Preconditions.checkNotNull((Object)i18n, (Object)"i18n");
        this.urlBuilder = (DashboardUrlBuilder)Preconditions.checkNotNull((Object)urlBuilder, (Object)"urlBuilder");
        this.webResourceManager = (WebResourceManager)Preconditions.checkNotNull((Object)webResourceManager, (Object)"webResourceManager");
    }

    public ViewComponent createDashboardView(Iterable<DashboardTab> tabs, DashboardState selectedTabDashboardState, @Nullable String username, int maxGadgets, GadgetRequestContext gadgetRequestContext) {
        return new DashboardView(this.renderer, this.getVisibleTabs(tabs, username), this.stateConverter.convertStateToDashboard(selectedTabDashboardState, gadgetRequestContext), username, maxGadgets, gadgetRequestContext, this.dashboardPermissionService.isWritableBy(selectedTabDashboardState.getId(), username), this.directoryPermissionService.canConfigureDirectory(username), this.dashboardEmbedder, this.webItemFinder, this.urlBuilder, this.i18n, this.webResourceManager);
    }

    private Iterable<Tab> getVisibleTabs(Iterable<DashboardTab> tabs, String username) {
        ArrayList<Tab> ret = new ArrayList<Tab>();
        for (DashboardTab tab : tabs) {
            if (!this.dashboardPermissionService.isReadableBy(tab.getDashboardId(), username)) continue;
            ret.add(new TabImpl(tab, this.dashboardPermissionService.isWritableBy(tab.getDashboardId(), username)));
        }
        return ret;
    }
}

