/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.gadgets.dashboard.internal.util;

import com.atlassian.gadgets.GadgetState;
import com.atlassian.gadgets.dashboard.internal.UserPref;
import com.atlassian.gadgets.dashboard.internal.impl.UserPrefImpl;
import com.atlassian.gadgets.spec.DataType;
import com.atlassian.gadgets.spec.GadgetSpec;
import com.atlassian.gadgets.spec.UserPrefSpec;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Maps;
import java.util.HashMap;
import java.util.Map;

public class UserPreferencesTransformer {
    public static Iterable<UserPref> userPrefsFromGadgetSpec(GadgetSpec spec, GadgetState state) {
        HashMap definedUserPrefs = Maps.newHashMap();
        for (UserPrefSpec userPrefSpec : spec.getUserPrefs()) {
            definedUserPrefs.put(userPrefSpec.getName(), userPrefSpec);
        }
        ImmutableList.Builder ret = ImmutableList.builder();
        if (state.getUserPrefs() != null) {
            for (Map.Entry userPref : state.getUserPrefs().entrySet()) {
                String key = (String)userPref.getKey();
                if (definedUserPrefs.containsKey(key)) {
                    UserPrefSpec userPrefSpec = (UserPrefSpec)definedUserPrefs.remove(key);
                    ret.add((Object)new UserPrefImpl(userPrefSpec, (String)userPref.getValue()));
                    continue;
                }
                UserPrefSpec hiddenSpec = UserPrefSpec.userPrefSpec((String)key).dataType(DataType.HIDDEN).build();
                ret.add((Object)new UserPrefImpl(hiddenSpec, (String)userPref.getValue()));
            }
        }
        for (Map.Entry userPrefSpecEntry : definedUserPrefs.entrySet()) {
            ret.add((Object)new UserPrefImpl((UserPrefSpec)userPrefSpecEntry.getValue(), null));
        }
        return ret.build();
    }
}

