/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.gadgets.dashboard.internal.rest.representations;

import com.atlassian.gadgets.dashboard.internal.UserPref;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import org.apache.commons.lang.StringEscapeUtils;
import org.apache.commons.lang.builder.EqualsBuilder;

@XmlRootElement
public final class UserPrefRepresentation {
    @XmlElement
    private final String name;
    @XmlElement
    private final String value;
    @XmlElement
    private final String type;
    @XmlElement
    private final String displayName;
    @XmlElement
    private final boolean required;
    @XmlElement
    private final List<EnumValueRepresentation> options;

    public UserPrefRepresentation(UserPref userPref) {
        this.name = StringEscapeUtils.escapeHtml((String)userPref.getName());
        this.value = StringEscapeUtils.escapeHtml((String)(userPref.getValue() == null ? userPref.getDefaultValue() : userPref.getValue()));
        this.type = userPref.getDataType().name().toLowerCase(Locale.ENGLISH);
        this.displayName = StringEscapeUtils.escapeHtml((String)userPref.getDisplayName());
        this.required = userPref.isRequired();
        this.options = this.transformEnumValues(userPref.getEnumValues(), this.value);
    }

    private List<EnumValueRepresentation> transformEnumValues(Map<String, String> enumValues, String selectedValue) {
        ArrayList<EnumValueRepresentation> result = new ArrayList<EnumValueRepresentation>();
        for (Map.Entry<String, String> enumValueEntry : enumValues.entrySet()) {
            boolean isDefaultValue = new EqualsBuilder().append((Object)selectedValue, (Object)enumValueEntry.getKey()).isEquals();
            result.add(new EnumValueRepresentation(enumValueEntry.getKey(), enumValueEntry.getValue(), isDefaultValue));
        }
        return result;
    }

    private UserPrefRepresentation() {
        this.type = null;
        this.displayName = null;
        this.name = null;
        this.value = null;
        this.required = false;
        this.options = new ArrayList<EnumValueRepresentation>();
    }

    public String getName() {
        return this.name;
    }

    public String getValue() {
        return this.value;
    }

    public String getType() {
        return this.type;
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public boolean isRequired() {
        return this.required;
    }

    public List<EnumValueRepresentation> getOptions() {
        return new ArrayList<EnumValueRepresentation>(this.options);
    }

    @XmlRootElement
    public static class EnumValueRepresentation {
        @XmlElement
        private final String value;
        @XmlElement
        private final String label;
        @XmlElement
        private final Boolean selected;

        public EnumValueRepresentation(String value, String label, boolean selected) {
            this.value = StringEscapeUtils.escapeHtml((String)value);
            this.label = StringEscapeUtils.escapeHtml((String)label);
            this.selected = selected;
        }

        private EnumValueRepresentation() {
            this.value = null;
            this.label = null;
            this.selected = null;
        }

        public String getValue() {
            return this.value;
        }

        public String getLabel() {
            return this.label;
        }

        public Boolean isSelected() {
            return this.selected;
        }
    }
}

