/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.gadgets.dashboard.internal.rest.representations;

import com.atlassian.gadgets.GadgetId;
import com.atlassian.gadgets.dashboard.DashboardId;
import com.atlassian.gadgets.dashboard.internal.DashboardUrlBuilder;
import com.atlassian.gadgets.dashboard.internal.Gadget;
import com.atlassian.gadgets.dashboard.internal.rest.representations.RenderedGadgetUriProvider;
import org.apache.commons.lang.StringUtils;

public final class GadgetUrlContainer {
    private final String colorUri;
    private final String gadgetUri;
    private final String userPrefsUri;
    private final String renderedGadgetUri;
    private final String titleUri;

    GadgetUrlContainer(DashboardUrlBuilder dashboardUrlBuilder, DashboardId dashboardId, Gadget gadget, RenderedGadgetUriProvider renderedGadgetUriprovider) {
        GadgetId gadgetId = gadget.getId();
        String titleUrlString = !gadget.isLoaded() || gadget.getTitleUrl() == null ? null : gadget.getTitleUrl().toASCIIString();
        this.titleUri = StringUtils.isNotBlank(titleUrlString) ? titleUrlString : null;
        this.colorUri = dashboardUrlBuilder.buildGadgetColorUrl(dashboardId, gadgetId);
        this.gadgetUri = dashboardUrlBuilder.buildGadgetUrl(dashboardId, gadgetId);
        this.userPrefsUri = dashboardUrlBuilder.buildGadgetUserPrefsUrl(dashboardId, gadgetId);
        this.renderedGadgetUri = renderedGadgetUriprovider.getRenderedGadgetUri();
    }

    public String getColorUri() {
        return this.colorUri;
    }

    public String getGadgetUri() {
        return this.gadgetUri;
    }

    public String getRenderedGadgetUri() {
        return this.renderedGadgetUri;
    }

    public String getUserPrefsUri() {
        return this.userPrefsUri;
    }

    public String getTitleUri() {
        return this.titleUri;
    }
}

