/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.gadgets.dashboard.internal.rest.representations;

import com.atlassian.fugue.Option;
import com.atlassian.gadgets.GadgetRequestContext;
import com.atlassian.gadgets.dashboard.DashboardId;
import com.atlassian.gadgets.dashboard.DashboardState;
import com.atlassian.gadgets.dashboard.internal.Gadget;
import com.atlassian.gadgets.dashboard.internal.rest.representations.GadgetUrlContainer;
import com.atlassian.gadgets.util.DashboardItemSerializers;
import com.atlassian.gadgets.view.View;
import com.google.common.collect.ImmutableMap;
import java.util.Map;

final class GadgetRenderingContext {
    private final DashboardId dashboardId;
    private final GadgetRequestContext gadgetRequestContext;
    private final Gadget gadget;
    private final GadgetUrlContainer gadgetUrls;
    private final DashboardState.ColumnIndex column;

    GadgetRenderingContext(DashboardId dashboardId, GadgetRequestContext gadgetRequestContext, Gadget gadget, GadgetUrlContainer gadgetUrls, DashboardState.ColumnIndex column) {
        this.dashboardId = dashboardId;
        this.gadgetRequestContext = gadgetRequestContext;
        this.gadget = gadget;
        this.gadgetUrls = gadgetUrls;
        this.column = column;
    }

    public Gadget getGadget() {
        return this.gadget;
    }

    public GadgetUrlContainer getGadgetUrls() {
        return this.gadgetUrls;
    }

    public DashboardState.ColumnIndex getColumn() {
        return this.column;
    }

    public DashboardId getDashboardId() {
        return this.dashboardId;
    }

    public GadgetRequestContext getGadgetRequestContext() {
        return this.gadgetRequestContext;
    }

    public Map<String, Object> getSerializedContext() {
        ImmutableMap.Builder contextBuilder = ImmutableMap.builder();
        contextBuilder.put((Object)"dashboard", DashboardItemSerializers.serializeDashboard((DashboardId)this.dashboardId));
        contextBuilder.put((Object)"dashboardItem", (Object)ImmutableMap.of((Object)"id", (Object)this.getGadget().getId().value(), (Object)"properties", this.gadget.getProperties()));
        Option user = this.gadgetRequestContext.getUser();
        if (user.isDefined()) {
            contextBuilder.put((Object)"user", DashboardItemSerializers.serializeUser((GadgetRequestContext.User)((GadgetRequestContext.User)user.get())));
        }
        contextBuilder.put((Object)"view", DashboardItemSerializers.serializeView((View)this.gadgetRequestContext.getView()));
        return contextBuilder.build();
    }
}

