/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.gadgets.dashboard.internal.rest;

import com.atlassian.event.api.EventPublisher;
import com.atlassian.gadgets.GadgetId;
import com.atlassian.gadgets.GadgetRequestContext;
import com.atlassian.gadgets.dashboard.DashboardId;
import com.atlassian.gadgets.dashboard.Layout;
import com.atlassian.gadgets.dashboard.internal.Dashboard;
import com.atlassian.gadgets.dashboard.internal.DashboardRepository;
import com.atlassian.gadgets.dashboard.internal.GadgetLayoutException;
import com.atlassian.gadgets.dashboard.internal.InconsistentDashboardStateException;
import com.atlassian.gadgets.dashboard.internal.rest.ChangeLayoutHandler;
import com.atlassian.gadgets.dashboard.spi.GadgetLayout;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.sal.api.message.I18nResolver;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import javax.ws.rs.core.Response;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.builder.ToStringBuilder;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class ChangeLayoutHandlerImpl
implements ChangeLayoutHandler {
    private final Log log = LogFactory.getLog(ChangeLayoutHandlerImpl.class);
    private final DashboardRepository repository;
    private final I18nResolver i18n;
    private final EventPublisher eventPublisher;

    @Autowired
    public ChangeLayoutHandlerImpl(DashboardRepository repository, @ComponentImport I18nResolver i18n, @ComponentImport EventPublisher eventPublisher) {
        this.repository = repository;
        this.i18n = i18n;
        this.eventPublisher = eventPublisher;
    }

    @Override
    public Response changeLayout(DashboardId dashboardId, GadgetRequestContext gadgetRequestContext, JSONObject newLayout) {
        String layout = newLayout.optString("layout");
        Dashboard dashboard = this.repository.get(dashboardId, gadgetRequestContext);
        try {
            this.eventPublisher.publish((Object)new LayoutChangedEvent(gadgetRequestContext.getViewer(), dashboardId, layout));
            if (StringUtils.isBlank((String)layout)) {
                return this.rearrangeGadgets(dashboard, newLayout);
            }
            return this.persistLayout(dashboard, newLayout);
        }
        catch (GadgetLayoutException e) {
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).type("text/plain").entity((Object)this.i18n.getText("error.changing.dashboard.layout", new Serializable[]{e.getMessage()})).build();
        }
        catch (ParseGadgetLayoutException e) {
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).type("text/plain").entity((Object)this.i18n.getText("error.changing.dashboard.layout", new Serializable[]{e.getMessage()})).build();
        }
        catch (IOException ioe) {
            return Response.serverError().type("text/plain").entity((Object)this.i18n.getText("error.changing.dashboard.layout", new Serializable[]{ioe.getMessage()})).build();
        }
        catch (InconsistentDashboardStateException idse) {
            this.log.error((Object)"ChangeLayoutHandlerImpl: Unexpected error occurred", (Throwable)idse);
            return Response.status((Response.Status)Response.Status.CONFLICT).type("text/plain").entity((Object)this.i18n.getText("error.please.reload")).build();
        }
    }

    private Response rearrangeGadgets(Dashboard dashboard, JSONObject newLayout) {
        GadgetLayout gadgetLayout = this.parseGadgetLayout(dashboard.getLayout(), newLayout);
        dashboard.rearrangeGadgets(gadgetLayout);
        this.repository.save(dashboard);
        return Response.noContent().build();
    }

    private Response persistLayout(Dashboard dashboard, JSONObject newLayout) throws IOException {
        Layout layout;
        String layoutParam = null;
        try {
            layoutParam = newLayout.getString("layout");
            layout = Layout.valueOf((String)layoutParam);
        }
        catch (IllegalArgumentException e) {
            return this.invalidLayout(layoutParam);
        }
        catch (JSONException e) {
            return this.invalidLayout(layoutParam);
        }
        GadgetLayout gadgetLayout = this.parseGadgetLayout(layout, newLayout);
        dashboard.changeLayout(layout, gadgetLayout);
        this.repository.save(dashboard);
        return Response.noContent().build();
    }

    private Response invalidLayout(String layoutParam) {
        return Response.status((Response.Status)Response.Status.BAD_REQUEST).type("text/plain").entity((Object)this.i18n.getText("invalid.layout.parameter", new Serializable[]{layoutParam, Layout.values()})).build();
    }

    private GadgetLayout parseGadgetLayout(Layout layout, JSONObject newLayout) throws ParseGadgetLayoutException {
        ArrayList<List<Object>> columns = new ArrayList<List<Object>>(layout.getNumberOfColumns());
        columns.addAll(Collections.nCopies(layout.getNumberOfColumns(), Collections.emptyList()));
        for (int i = 0; i < columns.size(); ++i) {
            try {
                JSONArray gadgetIds = newLayout.optJSONArray(Integer.toString(i));
                if (gadgetIds == null) continue;
                columns.set(i, this.toGadgetIds(gadgetIds));
                continue;
            }
            catch (NumberFormatException e) {
                throw new ParseGadgetLayoutException("gadget ids must be integers");
            }
            catch (JSONException e) {
                throw new ParseGadgetLayoutException("could not parse layout JSON: " + newLayout);
            }
        }
        return new GadgetLayout(columns);
    }

    private List<GadgetId> toGadgetIds(JSONArray gadgetIds) throws NumberFormatException, JSONException {
        LinkedList<GadgetId> columnLayout = new LinkedList<GadgetId>();
        for (int i = 0; i < gadgetIds.length(); ++i) {
            columnLayout.add(GadgetId.valueOf((String)gadgetIds.getString(i)));
        }
        return columnLayout;
    }

    public static final class LayoutChangedEvent {
        public final DashboardId dashboardId;
        public final String user;
        public final String layout;

        public LayoutChangedEvent(String user, DashboardId dashboardId, String layout) {
            this.user = user;
            this.dashboardId = dashboardId;
            this.layout = layout;
        }

        public String toString() {
            return ToStringBuilder.reflectionToString((Object)this);
        }
    }

    private final class ParseGadgetLayoutException
    extends RuntimeException {
        public ParseGadgetLayoutException(String message) {
            super(message);
        }
    }
}

