/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.gadgets.dashboard.internal.rest;

import com.atlassian.gadgets.GadgetId;
import com.atlassian.gadgets.GadgetRequestContext;
import com.atlassian.gadgets.dashboard.Color;
import com.atlassian.gadgets.dashboard.DashboardId;
import com.atlassian.gadgets.dashboard.internal.Dashboard;
import com.atlassian.gadgets.dashboard.internal.DashboardRepository;
import com.atlassian.gadgets.dashboard.internal.InconsistentDashboardStateException;
import com.atlassian.gadgets.dashboard.internal.rest.ChangeGadgetColorHandler;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.sal.api.message.I18nResolver;
import javax.ws.rs.core.Response;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class ChangeGadgetColorHandlerImpl
implements ChangeGadgetColorHandler {
    private final Log log = LogFactory.getLog(ChangeGadgetColorHandlerImpl.class);
    private final DashboardRepository repository;
    private final I18nResolver i18n;

    @Autowired
    public ChangeGadgetColorHandlerImpl(DashboardRepository repository, @ComponentImport I18nResolver i18n) {
        this.repository = repository;
        this.i18n = i18n;
    }

    @Override
    public Response setGadgetColor(DashboardId dashboardId, GadgetRequestContext gadgetRequestContext, GadgetId gadgetId, Color color) {
        Dashboard dashboard = this.repository.get(dashboardId, gadgetRequestContext);
        dashboard.changeGadgetColor(gadgetId, color);
        try {
            this.repository.save(dashboard);
        }
        catch (InconsistentDashboardStateException idse) {
            this.log.error((Object)"ChangeGadgetColorHandlerImpl: Unexpected error occurred: ", (Throwable)idse);
            return Response.status((Response.Status)Response.Status.CONFLICT).type("text/plain").entity((Object)this.i18n.getText("error.please.reload")).build();
        }
        return Response.noContent().build();
    }
}

