/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.gadgets.dashboard.internal.impl;

import com.atlassian.gadgets.GadgetId;
import com.atlassian.gadgets.GadgetState;
import com.atlassian.gadgets.dashboard.Color;
import com.atlassian.gadgets.dashboard.internal.Gadget;
import com.atlassian.gadgets.dashboard.internal.SpecificationBasedDashboardItem;
import com.atlassian.gadgets.dashboard.internal.UserPref;
import com.atlassian.gadgets.dashboard.internal.util.UserPreferencesTransformer;
import com.atlassian.gadgets.spec.DataType;
import com.atlassian.gadgets.spec.GadgetSpec;
import com.atlassian.gadgets.view.ViewType;
import com.google.common.base.Predicate;
import com.google.common.collect.Iterables;
import java.net.URI;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang.StringUtils;

public final class OpenSocialGadget
extends SpecificationBasedDashboardItem {
    private final GadgetId id;
    private final URI storedSpecUri;
    private final GadgetSpec gadgetSpec;
    private Color color;
    private Iterable<UserPref> userPrefs;
    private String errorMessage;
    private GadgetState stateOnLoadAttempt;
    private static final Predicate<UserPref> isNotHidden = new Predicate<UserPref>(){

        public boolean apply(UserPref userPref) {
            return !DataType.HIDDEN.equals((Object)userPref.getDataType());
        }
    };

    public OpenSocialGadget(GadgetState state, GadgetSpec gadgetSpec) {
        this.id = state.getId();
        this.storedSpecUri = state.getGadgetSpecUri();
        this.gadgetSpec = gadgetSpec;
        this.color = state.getColor();
        this.errorMessage = null;
        this.stateOnLoadAttempt = state;
        this.userPrefs = UserPreferencesTransformer.userPrefsFromGadgetSpec(gadgetSpec, state);
    }

    public OpenSocialGadget(GadgetState stateOnLoadAttempt, String errorMessage) {
        this.id = stateOnLoadAttempt.getId();
        this.color = stateOnLoadAttempt.getColor();
        this.storedSpecUri = stateOnLoadAttempt.getGadgetSpecUri();
        this.errorMessage = errorMessage;
        this.stateOnLoadAttempt = stateOnLoadAttempt;
        this.gadgetSpec = null;
    }

    @Override
    public GadgetId getId() {
        return this.id;
    }

    @Override
    public String getTitle() {
        this.checkLoaded();
        return this.gadgetSpec.getTitle();
    }

    @Override
    public URI getTitleUrl() {
        this.checkLoaded();
        return this.gadgetSpec.getTitleUrl();
    }

    @Override
    public String getGadgetSpecUrl() {
        return this.storedSpecUri.toASCIIString();
    }

    @Override
    public Integer getHeight() {
        this.checkLoaded();
        return this.gadgetSpec.getHeight() != 0 ? Integer.valueOf(this.gadgetSpec.getHeight()) : null;
    }

    @Override
    public Integer getWidth() {
        this.checkLoaded();
        return this.gadgetSpec.getWidth() != 0 ? Integer.valueOf(this.gadgetSpec.getWidth()) : null;
    }

    @Override
    public Color getColor() {
        return this.color;
    }

    @Override
    public boolean isMaximizable() {
        this.checkLoaded();
        return this.gadgetSpec.supportsViewType(ViewType.CANVAS);
    }

    @Override
    public boolean hasNonHiddenUserPrefs() {
        this.checkLoaded();
        return Iterables.any(this.userPrefs, isNotHidden);
    }

    @Override
    public Iterable<UserPref> getUserPrefs() {
        this.checkLoaded();
        return this.userPrefs;
    }

    public GadgetState getState() {
        if (this.isLoaded()) {
            return GadgetState.gadget((GadgetId)this.id).specUri(this.storedSpecUri).color(this.color).userPrefs(this.createStateFrom(this.userPrefs)).build();
        }
        return this.stateOnLoadAttempt;
    }

    private Map<String, String> createStateFrom(Iterable<UserPref> userPrefs) {
        HashMap<String, String> userPrefValues = new HashMap<String, String>();
        for (UserPref userPref : userPrefs) {
            if (userPref.isRequired() && !StringUtils.isNotBlank((String)userPref.getValue())) continue;
            userPrefValues.put(userPref.getName(), userPref.getValue());
        }
        return userPrefValues;
    }

    @Override
    public String getErrorMessage() {
        return this.errorMessage;
    }

    @Override
    public boolean isLoaded() {
        return this.gadgetSpec != null;
    }

    private void checkLoaded() {
        if (!this.isLoaded()) {
            throw new IllegalStateException("gadget could not be loaded");
        }
    }

    @Override
    public <T> T accept(Gadget.Visitor<T> visitor) {
        return visitor.visit(this);
    }
}

