/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.gadgets.dashboard.internal.impl;

import com.atlassian.gadgets.GadgetId;
import com.atlassian.gadgets.GadgetState;
import com.atlassian.gadgets.dashboard.Color;
import com.atlassian.gadgets.dashboard.internal.Gadget;
import com.atlassian.gadgets.dashboard.internal.SpecificationBasedDashboardItem;
import com.atlassian.gadgets.dashboard.internal.UserPref;
import com.atlassian.gadgets.dashboard.internal.util.UserPreferencesTransformer;
import com.atlassian.gadgets.plugins.DashboardItemModule;
import com.atlassian.gadgets.spec.GadgetSpec;
import com.atlassian.gadgets.view.ViewType;
import java.net.URI;

public class OpenSocialDashboardItem
extends SpecificationBasedDashboardItem {
    private final DashboardItemModule dashboardItemModule;
    private final String dashboardItemModuleKey;
    private final GadgetSpec gadgetSpec;
    private final GadgetId id;
    private final Color color;
    private final Iterable<UserPref> userPrefs;
    private final GadgetState gadgetState;

    public OpenSocialDashboardItem(GadgetState state, DashboardItemModule dashboardItemModule, String dashboardItemModuleKey, GadgetSpec gadgetSpec) {
        this.dashboardItemModule = dashboardItemModule;
        this.dashboardItemModuleKey = dashboardItemModuleKey;
        this.gadgetSpec = gadgetSpec;
        this.id = state.getId();
        this.color = state.getColor();
        this.gadgetState = state;
        this.userPrefs = UserPreferencesTransformer.userPrefsFromGadgetSpec(gadgetSpec, state);
    }

    @Override
    public GadgetId getId() {
        return this.id;
    }

    @Override
    public String getTitle() {
        return this.gadgetSpec.getTitle();
    }

    @Override
    public URI getTitleUrl() {
        return null;
    }

    @Override
    public String getGadgetSpecUrl() {
        return this.dashboardItemModuleKey;
    }

    @Override
    public Integer getHeight() {
        return this.gadgetSpec.getHeight();
    }

    @Override
    public Integer getWidth() {
        return this.gadgetSpec.getWidth();
    }

    @Override
    public Color getColor() {
        return this.color;
    }

    @Override
    public boolean isMaximizable() {
        return this.gadgetSpec.supportsViewType(ViewType.CANVAS);
    }

    @Override
    public boolean hasNonHiddenUserPrefs() {
        return false;
    }

    @Override
    public Iterable<UserPref> getUserPrefs() {
        return this.userPrefs;
    }

    public GadgetState getState() {
        return this.gadgetState;
    }

    @Override
    public String getErrorMessage() {
        return null;
    }

    @Override
    public boolean isLoaded() {
        return true;
    }

    @Override
    public <T> T accept(Gadget.Visitor<T> visitor) {
        return visitor.visit(this);
    }

    public DashboardItemModule getDashboardItemModule() {
        return this.dashboardItemModule;
    }
}

