/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.gadgets.dashboard.internal.impl;

import com.atlassian.cache.Cache;
import com.atlassian.cache.CacheManager;
import com.atlassian.cache.CacheSettingsBuilder;
import com.atlassian.fugue.Option;
import com.atlassian.gadgets.dashboard.DashboardItemModules;
import com.atlassian.gadgets.plugins.DashboardItemModule;
import com.atlassian.gadgets.plugins.DashboardItemModuleDescriptor;
import com.atlassian.plugin.ModuleCompleteKey;
import com.atlassian.plugin.PluginAccessor;
import com.atlassian.plugin.event.PluginEventManager;
import com.atlassian.plugin.spring.scanner.annotation.export.ExportAsService;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.plugin.tracker.DefaultPluginModuleTracker;
import com.atlassian.plugin.tracker.PluginModuleTracker;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Function;
import com.google.common.collect.Iterables;
import javax.annotation.Nonnull;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component(value="dashboardItemModules")
@ExportAsService(value={DashboardItemModules.class})
public class DashboardItemModulesTracker
implements DashboardItemModules {
    private static final String BY_MODULE_URI_CACHE = "com.atlassian.gadgets.dashboard.dashboardItemsByUri";
    private static final String BY_MODULE_KEY_CACHE_NAME = "com.atlassian.gadgets.dashboard.dashboardItemsByModuleKey";
    private final Cache<String, DashboardItemModuleDescriptor> dashboardItemsWithUriToReplaceCache;
    private final Cache<ModuleCompleteKey, DashboardItemModuleDescriptor> dashboardItemsWithDirectoryDefinitionCache;
    private final PluginModuleTracker.Customizer<DashboardItemModule, DashboardItemModuleDescriptor> pluginTrackerCustomizer;
    private final DefaultPluginModuleTracker<DashboardItemModule, DashboardItemModuleDescriptor> pluginTracker;

    @Autowired
    public DashboardItemModulesTracker(@ComponentImport PluginAccessor pluginAccessor, @ComponentImport PluginEventManager pluginEventManager, @ComponentImport CacheManager cacheManager) {
        this.dashboardItemsWithUriToReplaceCache = cacheManager.getCache(BY_MODULE_URI_CACHE, null, new CacheSettingsBuilder().local().build());
        this.dashboardItemsWithDirectoryDefinitionCache = cacheManager.getCache(BY_MODULE_KEY_CACHE_NAME, null, new CacheSettingsBuilder().local().build());
        this.pluginTrackerCustomizer = new PluginModuleTracker.Customizer<DashboardItemModule, DashboardItemModuleDescriptor>(){

            public DashboardItemModuleDescriptor adding(DashboardItemModuleDescriptor descriptor) {
                Option uriToReplace = descriptor.getGadgetSpecUriToReplace();
                if (uriToReplace.isDefined()) {
                    DashboardItemModulesTracker.this.dashboardItemsWithUriToReplaceCache.put(uriToReplace.get(), (Object)descriptor);
                }
                if (descriptor.getDirectoryDefinition().isDefined()) {
                    DashboardItemModulesTracker.this.dashboardItemsWithDirectoryDefinitionCache.put((Object)new ModuleCompleteKey(descriptor.getCompleteKey()), (Object)descriptor);
                }
                return descriptor;
            }

            public void removed(DashboardItemModuleDescriptor descriptor) {
                Option uriToReplace = descriptor.getGadgetSpecUriToReplace();
                if (uriToReplace.isDefined()) {
                    DashboardItemModulesTracker.this.dashboardItemsWithUriToReplaceCache.remove(uriToReplace.get());
                }
                if (descriptor.getDirectoryDefinition().isDefined()) {
                    DashboardItemModulesTracker.this.dashboardItemsWithDirectoryDefinitionCache.remove((Object)new ModuleCompleteKey(descriptor.getCompleteKey()));
                }
            }
        };
        this.pluginTracker = new DefaultPluginModuleTracker(pluginAccessor, pluginEventManager, DashboardItemModuleDescriptor.class, this.pluginTrackerCustomizer);
    }

    public Option<DashboardItemModuleDescriptor> getDashboardItemModuleDescriptor(@Nonnull String uri) {
        return Option.option((Object)this.dashboardItemsWithUriToReplaceCache.get((Object)uri));
    }

    public Iterable<DashboardItemModuleDescriptor> getDashboardItemsWithDirectoryDefinition() {
        return Iterables.transform((Iterable)this.dashboardItemsWithDirectoryDefinitionCache.getKeys(), (Function)new Function<ModuleCompleteKey, DashboardItemModuleDescriptor>(){

            public DashboardItemModuleDescriptor apply(ModuleCompleteKey moduleCompleteKey) {
                return (DashboardItemModuleDescriptor)DashboardItemModulesTracker.this.dashboardItemsWithDirectoryDefinitionCache.get((Object)moduleCompleteKey);
            }
        });
    }

    public Option<DashboardItemModuleDescriptor> getDashboardItemForModuleKey(@Nonnull ModuleCompleteKey moduleCompleteKey) {
        return Option.option((Object)this.dashboardItemsWithDirectoryDefinitionCache.get((Object)moduleCompleteKey));
    }

    @VisibleForTesting
    PluginModuleTracker<DashboardItemModule, DashboardItemModuleDescriptor> getPluginModuleTracker() {
        return this.pluginTracker;
    }

    @VisibleForTesting
    PluginModuleTracker.Customizer<DashboardItemModule, DashboardItemModuleDescriptor> getPluginModuleTrackerCustomizer() {
        return this.pluginTrackerCustomizer;
    }
}

