/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.gadgets.dashboard.internal.impl;

import com.atlassian.gadgets.GadgetId;
import com.atlassian.gadgets.LocalDashboardItemState;
import com.atlassian.gadgets.dashboard.Color;
import com.atlassian.gadgets.dashboard.internal.Gadget;
import com.atlassian.gadgets.dashboard.internal.UserPref;
import com.atlassian.gadgets.dashboard.internal.impl.UserPrefImpl;
import com.atlassian.gadgets.plugins.DashboardItemModule;
import com.atlassian.gadgets.spec.DataType;
import com.atlassian.gadgets.spec.UserPrefSpec;
import com.google.common.base.Function;
import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Iterables;
import java.net.URI;
import java.util.Collections;
import java.util.Map;

public class DashboardItem
implements Gadget {
    private final GadgetId gadgetId;
    private final String title;
    private final Color color;
    private final LocalDashboardItemState state;
    private final DashboardItemModule dashboardItemModule;
    private final Map<String, Object> properties;

    public DashboardItem(GadgetId gadgetId, String title, Color color, LocalDashboardItemState state, DashboardItemModule dashboardItemModule, Map<String, String> properties) {
        this.dashboardItemModule = dashboardItemModule;
        this.gadgetId = (GadgetId)Preconditions.checkNotNull((Object)gadgetId);
        this.title = (String)Preconditions.checkNotNull((Object)title);
        this.color = (Color)Preconditions.checkNotNull((Object)color);
        this.state = (LocalDashboardItemState)Preconditions.checkNotNull((Object)state);
        this.properties = ImmutableMap.copyOf((Map)((Map)Objects.firstNonNull(properties, Collections.emptyMap())));
    }

    @Override
    public GadgetId getId() {
        return this.gadgetId;
    }

    @Override
    public String getTitle() {
        return this.title;
    }

    @Override
    public URI getTitleUrl() {
        return null;
    }

    @Override
    public Integer getHeight() {
        return 0;
    }

    @Override
    public Integer getWidth() {
        return 0;
    }

    @Override
    public Color getColor() {
        return this.color;
    }

    @Override
    public boolean isMaximizable() {
        return true;
    }

    @Override
    public boolean hasNonHiddenUserPrefs() {
        return false;
    }

    @Override
    public Iterable<UserPref> getUserPrefs() {
        return Iterables.transform(this.getProperties().entrySet(), (Function)new Function<Map.Entry<String, Object>, UserPref>(){

            public UserPref apply(Map.Entry<String, Object> property) {
                return new UserPrefImpl(UserPrefSpec.userPrefSpec((String)property.getKey()).dataType(DataType.STRING).build(), property.getValue().toString());
            }
        });
    }

    @Override
    public Map<String, Object> getProperties() {
        return this.properties;
    }

    public LocalDashboardItemState getState() {
        return this.state;
    }

    @Override
    public String getErrorMessage() {
        return null;
    }

    @Override
    public boolean isLoaded() {
        return true;
    }

    @Override
    public <T> T accept(Gadget.Visitor<T> visitor) {
        return visitor.visit(this);
    }

    public DashboardItemModule getDashboardItemModule() {
        return this.dashboardItemModule;
    }
}

